#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 26/11/2020

import vmp
import vmpsys as sys
import vmpcheck as check

##@package vmp_plugin
#
#Implements the interfaces of supported plugins from the framework

##Module import list(for plugin use)
modimp={}

##If it exists, it imports a module and returns its handle<BR>
#
##param modname module name<BR>
#@param return modules handle
def module_import(modname):
  if not modname in modimp:
    try:
      try:
        if not vmp.env.module_isinstalled(modname):
          vmp.except_s("Not Installed")
      except Exception as e:
        vmp.except_s(str(e))
      m=sys.module_import(modname,vmp.env.python_moduleimp())
      try:
        modimp[modname]=m.Module
      except:
        vmp.except_s("The module does not implement plugins")
    except Exception as e:
      vmp.except_s("Module import \'{0}\' error \'{1}\'".format(modname,str(e)))
  return modimp[modname]

##internal usage
def plug_obj(modname,plugname):
  m=module_import(modname)
  try:
    return m.plugin(plugname)
  except Exception as e:
    vmp.except_s("Plugin import \'{0}\' in Module \'{1}\' {2}".format(plugname,modname,str(e)))
 
##Import plugin type<BR>
#
#@param modname  module name<BR>
#@param plugname plugin name<BR>
#@param plugtype plugin type<BR>
#@param pardata plugin input parameters(the same for all plugins of the same type)<BR>
#@param vardata variable input parameters of the plugin(they can be different for plugins of the same type)<BR>
#@return plugin handler
def plugin_import(modname,plugname,ptype,pardata,vardata):
  plugobj=plug_obj(modname,plugname)
  try:
    plugin=plugobj.Plugin(pardata,vardata)
  except Exception as e:
    vmp.except_s("Plugin import \'{0}\' in Module \'{1}\' error \'{2}\'".format(plugname,modname,str(e)))
  if not ptype == plugin.ptype:
    vmp.except_s("Plugin import \'{0}\' in Module \'{1}\' invalid type \'{2}\'".format(plugname,modname,ptype))
  return plugin

##Import plugin topic<BR>
#
#@param modname  module name<BR>
#@param plugname plugin name<BR>
#@return plugin handler
def plugin_import_topic(modname,plugname):
  plugobj=plug_obj(modname,plugname)
  try:
    topic=plugobj.PluginTopic(modname,plugname)
  except Exception as e:
    vmp.except_s("Plugin import \'{0}\' in Module \'{1}\' error \'{2}\'".format(plugname,modname,str(e)))
  return topic

import vmp_plugin.base      as base
import vmp_plugin.format    as format
import vmp_plugin.formatio  as formatio

