/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/11/2020
 */
 
#include "vmp.h"
#include  "pylib.h"
#include  "packet.h"

#ifndef VAMPIRIA_PY_PACKET_H

#define VAMPIRIA_PY_PACKET_H 1

//!Python wrapper of the c++ namespace vampiria::packet in vmp_packet.(see c++ doc)
/*!
    Const c++ packet type in packet.h:<BR>P_RAW,P_ETHERNET,P_ARP, P_IPV4,P_UDP,P_TCP<BR>
    Function list in packet.h:<BR>
        packet_free(),arpsub_str_generic(),Ipv4_integrity_check(),Ipv4_adjust_check(),Tcp_integrity_check(),Tcp_adjust_check(),
        Udp_integrity_check(),Udp_adjust_check(),Arp_Ethernet_Ipv4_D(),Ethernet_D(),Ipv4_D(),Raw_D(),Tcp_D(),Udp_D()<BR>
    Function list in packet/datatypes/types.h:<BR>
        ethertype_str_generic(),ipproto_str_generic(),arphtype_str_generic()
                                                          
*/
/*!
    Packet class in packet.h:<BR>No Constructor<BR>
    Packet member function list:<BR>subtype(),read(),write(),pseudo_header(),get(),set(),print(),next_type(),next(),prev(),payload()
    Packet operator list: / , []
*/
/*!
     PacketHelper class in packet.h:<BR>Constructor PacketHelper()<BR>
     PacketHelper member function list:<BR>clone_type(),read(),write(),clone_hdr(),print_all()
*/
void packet_init(pylib::Module module);

#endif
