/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 15/02/2020
 */

#include "vmp.h"
#include "pylib.h"

#ifndef VAMPIRIA_PY_VMP_H

#define VAMPIRIA_PY_VMP_H 1

//!Python wrapper of the c++ namespace vampiria::vmp in vmp.(see c++ doc)
/*!
    Const c++ in vmp/basetypes.h":<BR>
    INTMIN,INTMAX,INT16MIN,INT16MAX,UINTMIN,UINTMAX,UINT16MIN,UINT16MAX,CHARMIN,CHARMAX,
    UCHAR_MIN,UCHAR_MAX
*/
/*!
    Function c++ in vmp/error.h:<BR> except_s()
*/
/*!
    Function c++ in vmp/io.h:<BR>init(),io_forced_unlock(),debug(),info(),warning(),error(),error_raw(),
    output(),output_raw(),output_file(),output_file_lines(),input(),input_file(),input_file_s(),exit_ok(),exit_failure()
*/
/*!
    Function c++ in vmp/lib.h:<BR>system_wrap(),getpid_wrap(),getuid_wrap(),geteuid_wrap(),pause_wrap
*/
/*!
    Function c++ in vmp/signal.h:<BR>signum(),sigstr(),sigcmp(),signal_wrap()
*/
void vmp_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::vmp::env in vmp.env.(see c++ doc)
/*!
    Function c++ in vmp/env.h:<BR>author(),email(),webpage(),license(),version(),vampiria_path(),vampiria_bin(),
                                  vampiria_lib(),vampiria_cache(),vampiria_home(),software_root(),software_path(),
                                  software_isinstalled(),modules_root(),module_path(),module_main_path(),module_manifest(),
                                  module_isinstalled(),frm_dtd(),python_exe(),python_env(),python_moduleimp(),python_main(),
                                  python_software_main(),python_files_check(),xml_hdr()
*/
void vmp_init_env(pylib::Module module);

//!Python wrapper of the c++ class vampiria::vmp::Buf in vmp.Buf(see c++ doc)
/*!
    Buf class in vmp/buf.h:<BR>Constructor Buf()<BR>
    Buf member function list:<BR>newsize(),size(),size_reading(),index(),get_index(),eob(),reset(),
    write_byte(),read_byte(),write_vector(),read_vector(),write_size(),read_size(),write_str(),read_str(),
    write_xstr(),read_xstr(),read_xstr_hm(),cat(),cathead(),write_buf(),read_buf(),cut()
*/
void vmp_init_buf(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::fs in vmp.fs.(see c++ doc)
/*!
    Function c++ in vmp/lib.h:<BR>unlink_wrap(),format_dirpath(),union_path(),mkdir_wrap(),rmdir_wrap(),chdir_wrap(),
    isdir(),isrdir(),iswdir(),isxdir(),getcwd_wrap(),listendir(),isfile(),isrfile(),iswfile(),isxfile()
*/
void vmp_init_fs(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::thread in vmp.thread.(see c++ doc)
/*!
    Thread class in vmp/thread.h:<BR>Constructor Thread(pylib::Objref *)-- input arguments derived class python<BR>
    Thread member function list:<BR>pth(),is_run(),is_self(),start(),stop(),cancel(),th_except(),run()
*/
/*!
    Mutex class in vmp/thread.h:<BR>Constructor Mutex()<BR>
    Thread member function list:<BR>lock(),unlock()
*/
/*!
    Blocking class in vmp/thread.h:<BR>Constructor Blocking()<BR>
    Blocking member function list:<BR>pause(),unblock()
*/
void vmp_init_thread(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::time in vmp.time.(see c++ doc)
/*!
     Function c++ in vmp/time.h:<BR>vsleep(),time_wrap(),ctime_wrap()
*/
/*!
     Timer class in vmp/time.h:<BR>Constructor Timer()<BR>
     Thread member function list:<BR>init(),now()
*/
void vmp_init_time(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::unicode in vmp.unicode.(see c++ doc)
/*!
    Function c++ in vmp/unicode.h:<BR>str_split(),str_join(),str_isdigit(),str_isxdigit(),str_isreal(),
    str_todigit(),str_todigit_range(),str_toreal(),str_toreal_range(),xstr_tobytes(),bytes_toxstr(),
    str_findsub(),str_isword(),str_format(),str_format_maxline(),str_format_end(),
    str_extract_char(),str_regex_posix_icase(),str_toxstr(),xstr_tostr(),bytes_toxstr_hm()
*/
void vmp_init_unicode(pylib::Module module);

//!Python wrapper of the c++ namespaces vampiria::vmp::utils in vmp.utils.(see c++ doc)
/*!
    Const c++ logger loglevel in vmp/utils.h":<BR>
    LOG_NO,LOG_DEBUG,LOG_INFO,LOG_WARN,LOG_ERR<BR>
    Logger class in vmp/utils.h:<BR>Constructor Logger<BR>
    Logger member function list:<BR>reset(),set(),write()
*/
void vmp_init_utils(pylib::Module module);

#endif

