/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 24/02/2020
 */

#include "vmp_.h"

void vmp_init_time(pylib::Module module)
{
    pylib::Module time=module.add_submodule("time");

    //vmp/time.h
    time.def_("vsleep",vmp::time::vsleep);
    time.def_("time_wrap",vmp::time::time_wrap);
    time.def_("ctime_wrap",vmp::time::ctime_wrap);
    
    pylib::Class<vmp::time::Timer> timer=time.class_<vmp::time::Timer>("Timer");
    timer.def_("init",&vmp::time::Timer::init);
    timer.def_("now",&vmp::time::Timer::now);
}

