/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 28/09/2020
 */
 
#include "openssl_.h"

void openssl_x509(pylib::Module module)
{
    pylib::Class<openssl::pkg::X509_Wrap> x509=module.class_<openssl::pkg::X509_Wrap>("X509_Wrap");
    x509.def_("reset",&openssl::pkg::X509_Wrap::reset);
    x509.def_("parent",&openssl::pkg::X509_Wrap::parent,false);
    x509.def_("version",&openssl::pkg::X509_Wrap::version);
    x509.def_("serial",&openssl::pkg::X509_Wrap::serial);
    x509.def_("signature_info",&openssl::pkg::X509_Wrap::signature_info);
    x509.def_("issuer",&openssl::pkg::X509_Wrap::issuer);
    x509.def_("validity_before",&openssl::pkg::X509_Wrap::validity_before);
    x509.def_("validity_after",&openssl::pkg::X509_Wrap::validity_after);
    x509.def_("subject",&openssl::pkg::X509_Wrap::subject);
    x509.def_("pubkey",&openssl::pkg::X509_Wrap::pubkey);
    x509.def_("id_issuer",&openssl::pkg::X509_Wrap::id_issuer);
    x509.def_("id_subject",&openssl::pkg::X509_Wrap::id_subject);
    x509.def_("extensions",&openssl::pkg::X509_Wrap::extensions);
    x509.def_("signature_data",&openssl::pkg::X509_Wrap::signature_data);
    x509.def_("fingerprint_sha1",&openssl::pkg::X509_Wrap::fingerprint_sha1);
    x509.def_("fingerprint_sha256",&openssl::pkg::X509_Wrap::fingerprint_sha256);
}

