/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 28/07/2020
 */

#ifndef VAMPIRIA_OPENSSL_PKG_LIB_H

#define VAMPIRIA_OPENSSL_PKG_LIB_H 1

namespace vampiria { namespace openssl { namespace pkg {

//! Returns string error openssl
vmp::str err_string();

//! Utility function to write the data of a BIO openssl in a vampiria buffer
/*!
     @param bio input bio
     @param buf output buf
     @return data size or 0 close bio.If error throw exception
*/
vmp_int bio_to_buf(BIO *bio,vmp::Buf *buf);

//! Utility function to write the data of a a vampiria buffer in a BIO openssl 
/*!
     @param buf input buf
     @param bio output bio
     @return data size or 0 close bio.If error throw exception
*/
vmp_int buf_to_bio(vmp::Buf *buf,BIO *bio);

}}}

#endif

