/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/01/2020
 */

#ifndef VAMPIRIA_PYLIB_CONVERTER_H

#define VAMPIRIA_PYLIB_CONVERTER_H 1

namespace vampiria { namespace pylib {

template<typename T>
pylib::Objref *Converter(T value,vmp_bool retfree)
{
    if(pylib::is_vector<T>::value_)
    {
       return pylib::is_vector<T>::Converter(value,retfree);
    }
    /*if(pylib::is_pair<T>::value_)
    {
        return pylib::is_pair<T>::Converter(value,retfree);
    }*/
    pylib::type_info t;
    if (pylib::is_pointer<T>::value_)
        t = pylib::unwrap_type_id((T) 0);
    else
        t = pylib::unwrap_type_id((T*)0);
    pylib::Objtype *obj=Registry::pytypeobj(t);
    if(is_pointer<T>::is_null(value))
        return retnone();
    pylib::Objref *ret=pylib::make_instance(obj);
    pylib::set_instance(ret,value,retfree);
    return ret;
}

template<>
pylib::Objref *Converter<vmp_char>(vmp_char value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_char *>(vmp_char *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uchar>(vmp_uchar value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uchar *>(vmp_uchar *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int>(vmp_int value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int *>(vmp_int *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint>(vmp_uint value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint *>(vmp_uint *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int16>(vmp_int16 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_int16 *>(vmp_int16 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint16>(vmp_uint16 value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_uint16 *>(vmp_uint16 *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_real>(vmp_real value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_real *>(vmp_real *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_bool>(vmp_bool value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp_bool *>(vmp_bool *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp::str>(vmp::str value,vmp_bool retfree);

template<>
pylib::Objref *Converter<vmp::str *>(vmp::str *value,vmp_bool retfree);

template<>
pylib::Objref *Converter<pylib::Objref *>(pylib::Objref *value,vmp_bool retfree);

}}

#endif
