/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

extern "C"
{

static vmp_int type_is_gc(pylib::Objtype *tobj)
{
      return tobj->tp_flags & Py_TPFLAGS_HEAPTYPE;
}

static vmp_int class_setattro(pylib::Objref *obj,pylib::Objref *name,pylib::Objref *value)
{
      return PyType_Type.tp_setattro(obj, name, value);
}

static pylib::Objtype class_metatype_object = {
    PyVarObject_HEAD_INIT(NULL, 0)
    const_cast<vmp_char*>("Vampiria.Pylib.Class"),
    PyType_Type.tp_basicsize,
    0,
    0,                                      /* tp_dealloc */
    0,                                      /* tp_print */
    0,                                      /* tp_getattr */
    0,                                      /* tp_setattr */
    0,                                      /* tp_compare */
    0,                                      /* tp_repr */
    0,                                      /* tp_as_number */
    0,                                      /* tp_as_sequence */
    0,                                      /* tp_as_mapping */
    0,                                      /* tp_hash */
    0,                                      /* tp_call */
    0,                                      /* tp_str */
    0,                                      /* tp_getattro */
    class_setattro,                         /* tp_setattro */
    0,                                      /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT // | Py_TPFLAGS_HAVE_GC
    | Py_TPFLAGS_BASETYPE,                  /* tp_flags */
    0,                                      /* tp_doc */
    0,                                      /* tp_traverse */
    0,                                      /* tp_clear */
    0,                                      /* tp_richcompare */
    0,                                      /* tp_weaklistoffset */
    0,                                      /* tp_iter */
    0,                                      /* tp_iternext */
    0,                                      /* tp_methods */
    0,                                      /* tp_members */
    0,                                      /* tp_getset */
    0, //&PyType_Type,                      /* tp_base */
    0,                                      /* tp_dict */
    0,                                      /* tp_descr_get */
    0,                                      /* tp_descr_set */
    0,                                      /* tp_dictoffset */
    0,                                      /* tp_init */
    0,                                      /* tp_alloc */
    0,                                      /* tp_new */
    0,                                      /* tp_free */
    (inquiry)type_is_gc,                    /* tp_is_gc */
    0,                                      /* tp_bases */
    0,                                      /* tp_mro */
    0,                                      /* tp_cache */
    0,                                      /* tp_subclasses */
    0,                                      /* tp_weaklist */
    0                                       /* tp_del */
};

static void instance_dealloc(pylib::Objref *inst)
{
    pylib::instance<> *kill_me =(pylib::instance<>*)inst;
    for (pylib::instance_cpp *p = kill_me->objects_,*next; p != 0; p = next)
    {
        next = p->next();
        p->~instance_cpp();
        pylib::instance_cpp::deallocate(inst, dynamic_cast<void*>(p));
    }
    if (kill_me->weakrefs_ != 0)
        PyObject_ClearWeakRefs(inst);
    pylib::decref(kill_me->dict_);
    Py_TYPE(inst)->tp_free(inst);
}

static pylib::Objref *instance_new(pylib::Objtype *type,pylib::Objref *,pylib::Objref *)
{
    vmp_size instance_size;
    try
    {  
        instance_size=pylib::pyobj_getattr<vmp_size>((pylib::Objref *)type,"__instance_size__");
    }
    catch(vmp::exception &x)
    {
        instance_size=0;
    }
    pylib::instance<> *result = (pylib::instance<>*)type->tp_alloc(type,instance_size);
    if (result)
        Py_SIZE(result) =-(static_cast<vmp_int>(offsetof(pylib::instance<>,storage_) + instance_size));
    return (pylib::Objref*)result;
}

static Objref* instance_get_dict(Objref *op, void*)
{
    pylib::instance<> *inst = (pylib::instance<> *)(op);
    if (inst->dict_ == 0)
        inst->dict_ = pylib::pydict_new();
    pylib::incref(inst->dict_);
    return inst->dict_;
}
    
static vmp_int instance_set_dict(Objref *op,Objref *dict, void*)
{
    pylib::instance<> *inst = (pylib::instance<> *)(op);
    pylib::decref(inst->dict_);
    pylib::incref(dict);      
    inst->dict_ = dict;
    return 0;
}

static PyGetSetDef instance_getsets[] = {
      {const_cast<vmp_char*>("__dict__"),instance_get_dict,instance_set_dict,0, 0},
      {0, 0, 0, 0, 0}
};

static PyMemberDef instance_members[] = {
      {const_cast<vmp_char*>("__weakref__"),T_OBJECT,offsetof(instance<>,weakrefs_),0, 0},
      {0, 0, 0, 0, 0}
};

static pylib::Objtype class_type_object = {
      PyVarObject_HEAD_INIT(NULL, 0)
      const_cast<vmp_char*>("Vampiria.Pylib.instance"),
      offsetof(pylib::instance<>,storage_),            /* tp_basicsize */
      1,                                      /* tp_itemsize */
      instance_dealloc,                       /* tp_dealloc */
      0,                                      /* tp_print */
      0,                                      /* tp_getattr */
      0,                                      /* tp_setattr */
      0,                                      /* tp_compare */
      0,                                      /* tp_repr */
      0,                                      /* tp_as_number */
      0,                                      /* tp_as_sequence */
      0,                                      /* tp_as_mapping */
      0,                                      /* tp_hash */
      0,                                      /* tp_call */
      0,                                      /* tp_str */
      0,                                      /* tp_getattro */
      0,                                      /* tp_setattro */
      0,                                      /* tp_as_buffer */
      Py_TPFLAGS_DEFAULT // | Py_TPFLAGS_HAVE_GC
      | Py_TPFLAGS_BASETYPE,          /* tp_flags */
      0,                                      /* tp_doc */
      0,                                      /* tp_traverse */
      0,                                      /* tp_clear */
      0,                                      /* tp_richcompare */
      offsetof(pylib::instance<>,weakrefs_),  /* tp_weaklistoffset */
      0,                                      /* tp_iter */
      0,                                      /* tp_iternext */
      0,                                      /* tp_methods */
      instance_members,                       /* tp_members */
      instance_getsets,                       /* tp_getset */
      0, //&PyBaseObject_Type,                /* tp_base */
      0,                                      /* tp_dict */
      0,                                      /* tp_descr_get */
      0,                                      /* tp_descr_set */
      offsetof(instance<>,dict_),                /* tp_dictoffset */
      0,                                      /* tp_init */
      PyType_GenericAlloc,                    /* tp_alloc */
      instance_new,                           /* tp_new */
      0,                                      /* tp_free */
      0,                                      /* tp_is_gc */
      0,                                      /* tp_bases */
      0,                                      /* tp_mro */
      0,                                      /* tp_cache */
      0,                                      /* tp_subclasses */
      0,                                      /* tp_weaklist */
      0                                       /* tp_del */
};

}

instance_cpp::instance_cpp(): next_(0)
{
}

instance_cpp::~instance_cpp()
{
}

instance_cpp *instance_cpp::next() const
{
    return next_;
}

void *instance_cpp::allocate(pylib::Objref *self_,vmp_size cpp_offset,vmp_size cpp_size)
{
    vmp_assert(PyType_IsSubtype(Py_TYPE(Py_TYPE(self_)), &class_metatype_object));
    pylib::instance<> *self = (pylib::instance<>*)self_;
    
    vmp_int cpp_total= cpp_offset + cpp_size;
    
    if (-Py_SIZE(self) >= cpp_total)
    {
        // holder_offset should at least point into the variable-sized part
        vmp_assert(cpp_offset >= offsetof(pylib::instance<>,storage_));

        // Record the fact that the storage is occupied, noting where it starts
        Py_SIZE(self) = cpp_offset;
        return (vmp_byte *)self + cpp_offset;
    }
    else
    {
        void *const result = PyMem_Malloc(cpp_size);
        if (result == 0)
            vmp::except_alloc();
        return result;
    }
}

void instance_cpp::install(pylib::Objref *self,vmp_bool retfree) throw()
{
     retfree_=retfree;
     vmp_assert(PyType_IsSubtype(Py_TYPE(Py_TYPE(self)), &class_metatype_object));
     next_ = ((pylib::instance<>*)self)->objects_;
     ((pylib::instance<>*)self)->objects_ = this;
}

void instance_cpp::deallocate(pylib::Objref *self, void* storage) throw()
{
    vmp_assert(PyType_IsSubtype(Py_TYPE(Py_TYPE(self)),&class_metatype_object));
    pylib::instance<> *s = (pylib::instance<> *)self;
    if (storage != (vmp_byte*)s + Py_SIZE(s))
        PyMem_Free(storage);
}

pylib::Objref *class_metatype()
{
      if (class_metatype_object.tp_dict == 0)
      {
          Py_TYPE(&class_metatype_object) = &PyType_Type;
          class_metatype_object.tp_base = &PyType_Type;
          if (PyType_Ready(&class_metatype_object))
              return 0;
      }
      return (pylib::Objref *)&class_metatype_object;
}

pylib::Objref *class_type()
{
     if (class_type_object.tp_dict == 0)
     {
         pylib::incref(class_metatype());
         Py_TYPE(&class_type_object) = (PyTypeObject *)class_metatype();
         class_type_object.tp_base = &PyBaseObject_Type;
         if (PyType_Ready(&class_type_object))
             return 0;
     }
     return (pylib::Objref *)&class_type_object;
}

pylib::Objref *class_metatype_eval(vmp::str name,vmp::str prefix)
{
    pylib::CArgs args(1);
    args.add<pylib::Objref *>(pylib::class_type());
    CKwArgs kw;
    kw.add<vmp::str>("__module__",prefix);
    pylib::Objref *cref=PyEval_CallFunction(pylib::class_metatype(),"UOO",name.c_str(),args.get_args(),kw.get_kwargs());
    if(cref == 0)
        vmp::except_s("pylib class_metatype_eval() fatal error to call eval function");
    return cref;
}

void *find_instance_impl(pylib::Objref* inst,type_info type)
{
      if (!Py_TYPE(Py_TYPE(inst)) ||!PyType_IsSubtype(Py_TYPE(Py_TYPE(inst)), &pylib::class_metatype_object))
          return 0;
      
      pylib::instance<>* self = reinterpret_cast<pylib::instance<>*>(inst);

      for (pylib::instance_cpp* match = self->objects_; match != 0; match = match->next())
      {
          void *const found = match->holds(type);
          if (found)
              return found;
      }
      return 0;
}

pylib::Objref *make_instance(pylib::Objtype *type)
{
      return instance_new(type,0,0);
}

typedef vmp::set<pylib::RegClass> registry_t;

registry_t& entries()
{
    static registry_t registry;
    return registry;
}

RegClass *Registry::lookup(pylib::type_info& t)
{
    registry_t::iterator p = entries().find(RegClass(t));
    vmp_assert(p == entries().end());
    vmp::pair<registry_t::const_iterator,bool> pos_ins=entries().insert(RegClass(t));
    return const_cast<RegClass*>(&*pos_ins.first);
}

pylib::Objtype *Registry::pytypeobj(pylib::type_info& t)
{
    registry_t::iterator p = entries().find(RegClass(t));
    vmp_assert((p != entries().end()) && (p->p_obj_ != 0));
    return p->p_obj_;
} 

}}

