/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/01/2020
 */

#define PY_SSIZE_T_CLEAN
#include <Python.h>
#include <structmember.h> //python3 lib

#ifndef VAMPIRIA_PYLIB_LIB_H

#define VAMPIRIA_PYLIB_LIB_H 1

namespace vampiria { namespace pylib {

//! Python Object  wrap
typedef PyObject Objref;

//! Python type Object  wrap	
typedef PyTypeObject Objtype;

//! Returns python None Object.(incref None used)                
/*!
    @return Python NOne object
*/
pylib::Objref *retnone();

//!Convert an object references to c ++ value
/*!
    @param obj input python object
    @return c++ value(exceprt error)	
*/
template<typename T>
T arg_from_python(pylib::Objref *obj);

//!Convert an c++ value to object references
/*!
    @param value input c++ value
    @param retfree Used for dynamically allocated objects.
When the python instance is freed if the retfree is true, the allocated memory is freed (default true). For pointers to objects where memory management is not managed by the wrapper function, it must be set in false
    @return Python object value(exceprt error)
*/
template<typename T>
pylib::Objref *Converter(T value,vmp_bool retfree=true);

//! Object Base for wrapper utilty
class Objbase
{
    protected:
        pylib::Objref *ref_; /*<References object*/
        vmp::str name_;    /*<Python name Object*/
        vmp::str prefix_;    /*<  Module path in which the object is inserted*/
    
    public:
	
        //! A constructor
        /*!
             @param ref     references python wrapper object
             @param name    Python  name object
             @param prefix  Module path in which the object is inserted
        */
        Objbase(pylib::Objref *ref,vmp::str name,vmp::str prefix="");
        
        //! A destructor
        virtual ~Objbase();
    
        //! Get references Object
        /*!
             @return references object(o error)
        */
        pylib::Objref *ref();

        //! Get fullname python Object(prefix_ + . + name_)
        /*!
             @return python fullname string 
        */
        vmp::str fullname();
};

}}

#endif

#include "lib/pybase.h"
#include "lib/typeinfo.h"
#include "lib/class_impl.h"
#include "lib/arg_from_python.h"
#include "lib/converter.h"
#include "lib/def.h"



