/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 28/01/2020
 */

#ifndef VAMPIRIA_PYLIB_CLASS_H

#define VAMPIRIA_PYLIB_CLASS_H 1

namespace vampiria { namespace pylib {

//!Class c++ to python wrapper utils(see pylib::ObjBase)
template <class Wrap>
class Class:public pylib::Objbase
{
    public:
	//! A constructor
        /*!
            @param ref references python wrapper class
            @param name Python class name
            @param prefix Module path in which the class is inserted
        */ 
        Class(pylib::Objref *ref,vmp::str name,vmp::str prefix):pylib::Objbase(ref,name,prefix){}
        
	//!A destructor
	~Class(){}

        //! Operator =
	const Class<Wrap> &operator=(Class<Wrap> &cclass)
        {
            ref_=cclass.ref_;
            name_=cclass.name_;
            prefix_=cclass.prefix_;
            return (*this);
        }

        //! Inserts a python function into the class following the code c++ of a stub
	/*!
	    @param name function name
	    @param stub stub member(see pylib::Member_def)
            @return void(except error)	
	*/
	template<class Stub_Member_t>
        void def_with_stub(vmp::str name,Stub_Member_t const &stub)
        {
            pylib::Def *def;
            py_function *p=new py_function(stub);
            try
            {
                def=(pylib::Def *)pyobj_getattr<pylib::Objref *>(ref(),name);
                def->insert_py(p);
            }
            catch(vmp::exception &x)
            {
                def=new pylib::Def(p,name,(*this));
            }

        }

	//! Inserts a python function into the class (wrapper c++ to python function)
	/*!
	     @param name  function name
	     @param fn function member class c++ to wrap
	     @param retfree Converter return free arg(see pylib::Converter) 
	     @return void(except error)	
	*/
        template <class Fn>
        void def_(vmp::str name,Fn fn,vmp_bool retfree=true)
        {
            def_with_stub(name,pylib::Member_default<Wrap,Fn>(fn,retfree));
        }
};

}}

#endif

