/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

vmp::str ethertype_str_generic(vmp_uint16 code)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"ethertype_%04X",code);
    return ret;
}

DataEtherType::DataEtherType(vmp::str field):packet::DataBytes(field)
{
    data_=0x0000;
    
    //insert packet code in library
    insert_code(packet::P_ARP,0x0806);
    insert_code(packet::P_IPV4,0x0800);
}
        
DataEtherType::~DataEtherType()
{
    vmp::table_delete_alldata<vmp_uint16,vmp::str *>(code_);
    vmp::table_delete_alldata<vmp::str,vmp_uint16 *>(strcode_);
}

void DataEtherType::insert_code(vmp::str strcode,vmp_uint16 code)
{
    vmp::str *str=new vmp::str();
    (*str)=strcode;
    vmp_uint16 *c=new vmp_uint16();
    (*c)=code;
    strcode_.insert(strcode,c);
    code_.insert(code,str);
}

vmp::str DataEtherType::get(vmp::str field)
{
    vmp::str *pret;
    if(code_.search(data_,&pret))
        return (*pret);
    return packet::ethertype_str_generic(data_);
}
        
void DataEtherType::set(vmp::str field,vmp::str data)
{
    vmp_uint16 *ret;
    if(strcode_.search(data,&ret))
        data_=(*ret);
    else
    {
        try
        {
            vmp::vector<vmp::str> split=vmp::unicode::str_split(data,"_");
            if(!((split.size() == 2) && (split[0] == "ethertype") && (split[1].size() == 4)))
                vmp::except_s("");
            vmp::vector<vmp_byte> bytes=vmp::unicode::xstr_tobytes(split[1]);
            data_=(vmp_uint16) bytes[0];
            data_=(data_ << 8) +(vmp_uint16) bytes[1];
        } 
        catch(vmp::exception &x)
        {
            vmp::except_s("Malformed ethertype");
        }
    }         
}

void DataEtherType::read(vmp::Buf *buf)
{
    data_=buf->read_size(2);
}
        
void DataEtherType::write(vmp::Buf *buf)
{
    buf->write_size(data_,2);
}

vmp_uint16 DataEtherType::get_data()
{
    return data_;
}

void DataEtherType::set_data(vmp_uint16 data)
{
    data_=data;
}

vmp::str ipproto_str_generic(vmp_byte code)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"ipproto_%02X",code);
    return ret;
}

DataIpProto::DataIpProto(vmp::str field):packet::DataBytes(field)
{
    data_=0x00;
    insert_code(packet::P_UDP,0x11);
    insert_code(packet::P_TCP,0x06);
}

DataIpProto::~DataIpProto()
{
    vmp::table_delete_alldata<vmp_byte,vmp::str *>(code_);
    vmp::table_delete_alldata<vmp::str,vmp_byte *>(strcode_);
}

void DataIpProto::insert_code(vmp::str strcode,vmp_byte code)
{
    vmp::str *str=new vmp::str();
    (*str)=strcode;
    vmp_byte *c=new vmp_byte();
    (*c)=code;
    strcode_.insert(strcode,c);
    code_.insert(code,str);   
}

vmp::str DataIpProto::get(vmp::str field)
{
    vmp::str *pret;
    if(code_.search(data_,&pret))
        return (*pret);
    return packet::ipproto_str_generic(data_);
}

void DataIpProto::set(vmp::str field,vmp::str data)
{
    vmp_byte *ret;
    if(strcode_.search(data,&ret))
        data_=(*ret);
    else
    {
        try
        {
            vmp::vector<vmp::str> split=vmp::unicode::str_split(data,"_");
            if(!((split.size() == 2) && (split[0] == "ipproto") && (split[1].size() == 2)))
                vmp::except_s("");
            vmp::vector<vmp_byte> bytes=vmp::unicode::xstr_tobytes(split[1]);
            data_=bytes[0];
        }
        catch(vmp::exception &x)
        {
            vmp::except_s("Malformed ipproto");
        }
    }
}

void DataIpProto::read(vmp::Buf *buf)
{
    data_=buf->read_byte();
}
        
void DataIpProto::write(vmp::Buf *buf)
{
    buf->write_byte(data_);
}

vmp_byte DataIpProto::get_data()
{
    return data_;
}

void DataIpProto::set_data(vmp_byte data)
{
    data_=data;
}

vmp::str arphtype_str_generic(vmp_uint16 code)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"arphtype_%04X",code);
    return ret;
}

DataArpHtype::DataArpHtype(vmp::str field):DataBytes(field)
{
    data_=0;
    insert_code(packet::P_ETHERNET,0x0001);
}
        
DataArpHtype::~DataArpHtype()
{
    vmp::table_delete_alldata<vmp_uint16,vmp::str *>(code_);
    vmp::table_delete_alldata<vmp::str,vmp_uint16 *>(strcode_);
}

void DataArpHtype::insert_code(vmp::str strcode,vmp_uint16 code)
{
    vmp::str *str=new vmp::str();
    (*str)=strcode;
    vmp_uint16 *c=new vmp_uint16();
    (*c)=code;
    strcode_.insert(strcode,c);
    code_.insert(code,str);
}
        
vmp::str DataArpHtype::get(vmp::str field)
{
    vmp::str *pret;
    if(code_.search(data_,&pret))
        return (*pret);
    return packet::arphtype_str_generic(data_);
}
        
void DataArpHtype::set(vmp::str field,vmp::str data)
{
    vmp_uint16 *ret;
    if(strcode_.search(data,&ret))
        data_=(*ret);
    else
    {
        try
        {
            vmp::vector<vmp::str> split=vmp::unicode::str_split(data,"_");
            if(!((split.size() == 2) && (split[0] == "arphtype") && (split[1].size() == 4)))
                vmp::except_s("");
            vmp::vector<vmp_byte> bytes=vmp::unicode::xstr_tobytes(split[1]);
            data_=(vmp_uint16) bytes[0];
            data_=(data_ << 8) +(vmp_uint16) bytes[1];
        } 
        catch(vmp::exception &x)
        {
            vmp::except_s("Malformed arphtype");
        }
    }         
}
        
void DataArpHtype::read(vmp::Buf *buf)
{
    data_=buf->read_size(2);    
}
        
void DataArpHtype::write(vmp::Buf *buf)
{
    buf->write_size(data_,2);
}

vmp_uint16 DataArpHtype::get_data()
{
    return data_;    
}
        
void DataArpHtype::set_data(vmp_uint16 data)
{
    data_=data;
}

}}
