/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/11/2020
 */

#ifndef VAMPIRIA_PACKET_ADDRESS_H

#define VAMPIRIA_PACKET_ADDRESS_H 1

namespace vampiria { namespace packet {

//! Data type mac address
class DataMac:public packet::DataBytes
{
    private:
        net::MacAddress mac_;/*!< data mac address*/
    public:
        //! A constructor
        /*!
            @param field data field
        */
        DataMac(vmp::str field);

        //! A destructor
        ~DataMac();

        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);

        //! Returns raw data mac address
        /*!
            @sa mac_
            @return pointer to mac address data
        */
        net::MacAddress *get_data();
};

//! Data type ipv4
class DataIpv4:public packet::DataBytes
{
    private:
        net::Address ipv4_;/*!< data ipv4 address*/
    public:
        //! A constructor
        /*!
            @param field data field
        */
        DataIpv4(vmp::str field);
        
        //! A destructor
        ~DataIpv4();

        //! Virtual function
        vmp::str get(vmp::str field);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void write(vmp::Buf *buf);

        //! Returns raw data ipv4 address
        /*!
            @sa ipv4_
            @return pointer to ipv4 address data
        */
        net::Address *get_data();
};

}}

#endif

