/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

TimerRef::TimerRef():event::EventTimer()
{
}
       
TimerRef::~TimerRef()
{
}

TimerUI::TimerUI(event::Manager *manager):UI(manager)
{
    set_event(0,0);
}

TimerUI::~TimerUI()
{
}

vmp::str TimerUI::identity(event::Cell *cell)
{
    vmp::str ret;
    TimerRef *tevent=cell->event<TimerRef>();
    vmp::unicode::str_write(&ret,"Timer event [id=%s][timeval=%f]",tevent->id_.c_str(),tevent->timeval_);
    return ret;
}

void TimerUI::close_event(event::Cell *cell)
{
    TimerRef *tevent=cell->event<TimerRef>();
    tevent->evt_timer_close();
}
        
void TimerUI::free_ref(event::Cell *cell)
{
    TimerRef *tevent=cell->event<TimerRef>();
    tevent->id_=""; 
    tevent->evt_timer_free();
    tref_.free(tevent);
}

void TimerUI::set_event(event::EVTCB event,event::EVTCB cevent)
{
    event_=event;
    cevent_=cevent;
}

event::Cell *TimerUI::new_timer(vmp::str id,vmp::time::Time timeval)
{
    event::Cell *cell;
    manager_->lock();
    TimerRef *tevent=tref_.get();
    try
    {
        cell=tevent->evt_timer_new(this,timeval,event_,cevent_);
        tevent->id_=id;
    }
    catch(vmp::exception &x)
    {
        tref_.free(tevent);
        manager_->unlock();
        vmp::except_s(x.what()); 
    }
    manager_->unlock();
    return cell;
}

void TimerUI::active_timer(event::Cell *cell,vmp::time::Time timeval)
{
    event::Manager *manager=cell->get_manager();
    TimerRef *tevent=cell->event<TimerRef>();
    manager->lock();
    try
    {
        tevent->evt_timer_active(timeval);    
    }
    catch(vmp::exception &x)
    {
        manager->unlock();
        vmp::except_s(x.what()); 
    }
    manager->unlock();
}

void TimerUI::deactive_timer(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    TimerRef *tevent=cell->event<TimerRef>();
    manager->lock();
    tevent->evt_timer_deactive();    
    manager->unlock();
}

vmp::time::Time TimerUI::get_timeval(event::Cell *cell)
{
    TimerRef *tevent=cell->event<TimerRef>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::time::Time timeval=tevent->timeval_;
    manager->unlock();
    return timeval;
}

vmp::str TimerUI::id(event::Cell *cell)
{
    TimerRef *tevent=cell->event<TimerRef>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str id=tevent->id_;
    manager->unlock();
    return id;
}

}}

