/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

void timer_ev(event::Cell *cell)
{
    vmp_bool exec=false;
    event::Manager *manager=cell->get_manager();
    EventTimer *event=cell->event<EventTimer>();
    manager->lock();
    if(event->active_)
    {
        if(event->timeactive_ <= manager->time_now())
        {
            exec=manager->cell_update(cell);
            if(exec)
            {
                event->timeactive_+=event->timeval_;
                manager->set_timeout(event->timeactive_);
            }
        }
        else
            manager->set_timeout(event->timeactive_);
    }
    manager->unlock();   
    if(exec)
        event->event_(cell);
}

EventTimer::EventTimer():event::Event()
{
}

EventTimer::~EventTimer()
{
} 

event::Cell *EventTimer::evt_timer_new(event::UI *ui,vmp::time::Time timeval,event::EVTCB event,event::EVTCB close)
{
    if(timeval <= 0.0)
        vmp::except("event::EventTimer::evt_timer_new() invalid timeval %f",timeval);
    event::Cell *ret=evt_new(ui,-1,timer_ev,close);
    if(event == 0)
        event_=event::empty_ev;
    else
        event_=event;
    evt_timer_active(timeval);
    return ret; 
}

void EventTimer::evt_timer_active(vmp::time::Time timeval)
{
    if(timeval <= 0.0)
        vmp::except("event::EventTimer::evt_timer_active() invalid timeval %f",timeval);
    timeval_=timeval;
    event::Manager *manager=cell_->get_manager();
    timeactive_=manager->time_now()+timeval_;
    manager->set_timeout(timeactive_);
    evt_active(true);
}

void EventTimer::evt_timer_deactive()
{
    evt_active(false);
}

void EventTimer::evt_timer_close()
{
    evt_close();
}

void EventTimer::evt_timer_free()
{
    evt_free();
    timeval_=0.0;
    timeactive_=0.0;
}

}}

