/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/03/2020
 */

#include "xml_.h"

void xml_init_wparser(pylib::Module module)
{
    //xml.h
    pylib::Class<xml::WTag> wtag=module.class_no_constructor<xml::WTag>("WTag");
    wtag.def_("set_text",&xml::WTag::set_text);
    wtag.def_("add_attr",&xml::WTag::add_attr);
    wtag.def_("add_child",&xml::WTag::add_child,false);
    wtag.def_("set_parent",&xml::WTag::set_parent);
    wtag.def_("get_parent",&xml::WTag::get_parent,false);

    //xml.h
    pylib::Class<xml::WParser> wparser=module.class_<xml::WParser>("WParser");
    wparser.def_("init",&xml::WParser::init,false);
    wparser.def_("write",&xml::WParser::write);
}



