/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/11/2020
 */

#include "packet_.h"

VAMPIRIA_PYLIB_INIT(vmp_packet_);

struct stub_packet_truediv:public pylib::Member_def<packet::Packet>
{
    pylib::Objref *def(packet::Packet *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            packet::Packet *packet=args.get<packet::Packet *>(0);
            packet::Packet *ret=(*instance)/packet;
            return pylib::Converter<packet::Packet *>(ret,false);
        }
        return 0;
    }
};

struct stub_packet_getitem:public pylib::Member_def<packet::Packet>
{
    pylib::Objref *def(packet::Packet *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str arg=args.get<vmp::str>(0);
            packet::Packet *ret=(*instance)[arg];
            return pylib::Converter<packet::Packet *>(ret,false);
        }
        return 0;
    }
};

void packet_init(pylib::Module module)
{
     module.add_const<vmp::str>("P_RAW",packet::P_RAW);
     module.add_const<vmp::str>("P_ETHERNET",packet::P_ETHERNET);	
     module.add_const<vmp::str>("P_ARP",packet::P_ARP);
     module.add_const<vmp::str>("P_IPV4",packet::P_IPV4);
     module.add_const<vmp::str>("P_UDP",packet::P_UDP);
     module.add_const<vmp::str>("P_TCP",packet::P_TCP);
	
     module.def_("packet_free",packet::packet_free);
     module.def_("arpsub_str_generic",packet::arpsub_str_generic);
     module.def_("Ipv4_integrity_check",packet::Ipv4_integrity_check);
     module.def_("Ipv4_adjust_check",packet::Ipv4_adjust_check);
     module.def_("Tcp_integrity_check",packet::Tcp_integrity_check);
     module.def_("Tcp_adjust_check",packet::Tcp_adjust_check);
     module.def_("Udp_integrity_check",packet::Udp_integrity_check);
     module.def_("Udp_adjust_check",packet::Udp_adjust_check);
	
     module.def_("ethertype_str_generic",packet::ethertype_str_generic);
     module.def_("ipproto_str_generic",packet::ipproto_str_generic);
     module.def_("arphtype_str_generic",packet::arphtype_str_generic);

     module.def_("Arp_Ethernet_Ipv4_D",packet::Arp_Ethernet_Ipv4_D,false);
     module.def_("Ethernet_D",packet::Ethernet_D,false);
     module.def_("Ipv4_D",packet::Ipv4_D,false);
     module.def_("Raw_D",packet::Raw_D,false);
     module.def_("Tcp_D",packet::Tcp_D,false);
     module.def_("Udp_D",packet::Udp_D,false);

     pylib::Class<packet::Packet> packet=module.class_no_constructor<packet::Packet>("Packet");
     packet.def_("subtype",&packet::Packet::subtype);
     packet.def_("read",&packet::Packet::read);
     packet.def_("write",&packet::Packet::write);
     packet.def_("pseudo_header",&packet::Packet::pseudo_header);
     packet.def_("get",&packet::Packet::get);
     packet.def_("set",&packet::Packet::set);
     packet.def_("print",&packet::Packet::print);
     packet.def_("next_type",&packet::Packet::next_type);
     packet.def_("next",&packet::Packet::write,false);
     packet.def_("prev",&packet::Packet::write,false);
     packet.def_("payload",&packet::Packet::payload);
     packet.def_with_stub("__truediv__",stub_packet_truediv());
     packet.def_with_stub("__getitem__",stub_packet_getitem());
     
     pylib::Class<packet::PacketHelper> hpacket=module.class_<packet::PacketHelper>("PacketHelper");
     hpacket.def_("clone_type",&packet::PacketHelper::clone_type);
     hpacket.def_("read",&packet::PacketHelper::read,false);
     hpacket.def_("write",&packet::PacketHelper::write);
     hpacket.def_("clone_hdr",&packet::PacketHelper::clone_hdr,false);
     hpacket.def_("print_all",&packet::PacketHelper::print_all);
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
     packet_init(init_module);
}
