/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/02/2020
 */

#include "net_.h"

struct stub_macaddress_set:public pylib::Member_def<net::MacAddress>
{
    pylib::Objref *def(net::MacAddress *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            try
            {
                vmp::str addr=args.get<vmp::str>(0);
                instance->set(addr);
                return pylib::retnone();
            }
            catch(vmp::invalid_argument &x)
            {
            }
            catch(vmp::exception &x)
            {
                vmp::except_s(x.what());
            }
            vmp::vector<vmp_byte> baddr= args.get<vmp::vector<vmp_byte> >(0);
            instance->set(baddr); 
            return pylib::retnone();
        }
        return 0;
    }
};

void net_init_macaddress(pylib::Module module)
{
    //net/address.h
    pylib::Class<net::MacAddress> mac=module.class_<net::MacAddress>("MacAddress");
    mac.def_("reset",&net::MacAddress::reset);
    mac.def_with_stub("set",stub_macaddress_set());
    mac.def_("str_addr",&net::MacAddress::str_addr);
    mac.def_("byte_addr",&net::MacAddress::byte_addr);
}

