/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/02/2020
 */

#include "vmp_.h"

class PyThread:public vmp::thread::Thread
{
    public:
        pylib::PyCall run_;

        PyThread();
        ~PyThread();

        void run();
        
};

PyThread::PyThread():Thread()
{
}

PyThread::~PyThread()
{
}

void PyThread::run()
{
    pylib::CArgs cargs(0);
    run_.call(cargs);
}

struct Pythread_stub_Constructor:public pylib::Constructor<PyThread>
{
    PyThread *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            PyThread *pythread=new PyThread();
            try
            {
                args.get_callable_member(0,"run",pythread->run_);
            }
            catch(vmp::exception &x)
            {
                delete pythread;
                args.arg_error();
            }
            return pythread;
        }
        return 0;
    }
};

struct stub_blocking_unblock:public pylib::Member_def<vmp::thread::Blocking>
{
    pylib::Objref *def(vmp::thread::Blocking *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            instance->unblock();
        else if(args.size() == 1)
        {
            vmp_byte b=args.get<vmp_byte>(0);
            instance->unblock(b);
        }
        else
            return 0;
        return pylib::retnone();
    }
};

void vmp_init_thread(pylib::Module module)
{
    pylib::Module thread=module.add_submodule("thread");
    
    pylib::Class<PyThread> thclass=thread.class_with_constructor<PyThread>("Thread",Pythread_stub_Constructor());
    thclass.def_("pth",&PyThread::pth);
    thclass.def_("is_run",&PyThread::is_run);
    thclass.def_("is_self",&PyThread::is_self);
    thclass.def_("start",&PyThread::start);
    thclass.def_("stop",&PyThread::stop);
    thclass.def_("cancel",&PyThread::cancel);
    thclass.def_("th_except",&PyThread::th_except);
    thclass.def_("run",&PyThread::run);

    pylib::Class<vmp::thread::Mutex> mutex=thread.class_<vmp::thread::Mutex>("Mutex");
    mutex.def_("lock",&vmp::thread::Mutex::lock);
    mutex.def_("unlock",&vmp::thread::Mutex::unlock);

    pylib::Class<vmp::thread::Blocking> blocking=thread.class_<vmp::thread::Blocking>("Blocking");
    blocking.def_("pause",&vmp::thread::Blocking::pause);
    blocking.def_with_stub("unblock",stub_blocking_unblock());
}

