#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 02/12/2020

import vmp
import vmp_plugin as plugin

PluginName="hexa_formatio"

class Plugin(plugin.formatio.Plugin):
  def __init__(self,data,options):
    plugin.formatio.Plugin.__init__(self,data,options)
    self.delimiter=self.opt_get("delimiter",0,'')
    try:
      if not ((len(self.delimiter) % 2) == 0):  
        vmp.except_s("")
      self.delimiter=vmp.unicode.xstr_tostr(self.delimiter,'')
    except:
      self.opt_err("delimiter")
 
  def input(self):
    try:
      ret=vmp.input()
      return vmp.unicode.xstr_tostr(ret,self.delimiter)
    except Exception as e:
      vmp.except_s("hexa_formatio::input() invalid input {0}".format(str(e)))
      
  def output(self,value):
    out=vmp.unicode.str_toxstr(value,self.delimiter)
    vmp.output(out)

  def output_raw(self,value):
    out=vmp.unicode.str_toxstr(value,self.delimiter)
    vmp.output_raw(value)

class PluginTopic(plugin.formatio.PluginTopic):
  def __init__(self,modname,plugname):
    plugin.formatio.PluginTopic.__init__(self,modname,plugname)
    self.set_desc("Plugin used to manage data received and written by std in hexadecimal format.")
    self.set_function("input","Reads hexadecimal data from standard input and returns them converted to a normal string(throw exception error)")
    self.set_function("output","It takes a string as input and prints it to standard output in hexadecimal by adding the end of string character at the end")
    self.set_function("output_raw","It takes a string as input and prints it to standard output in hexadecimal(not new line end of string")
    self.add_option("delimiter","empty string","1",
                            "Used as separator data for bytes in hexadecimal representation.The string must be entered in hexadecimal format with each byte consisting of two positions. Example the string ':' must be entered as 3A")
    
