/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/07/2020
 */

#ifndef VAMPIRIA_OPENSSL_PKG_PKEY_H

#define VAMPIRIA_OPENSSL_PKG_PKEY_H 1

namespace vampiria { namespace openssl { namespace pkg {

//!Container used for openssl keys
class PKey
{
    private:
        //!Internal usage
        void pointer_except();

        //!Internal usage
        void key_info(vmp_int *pid,vmp_int *pnid,vmp_int *pflags,const vmp_char **pinfo,const vmp_char **ppem);
    public:
        //! A constructor
        PKey();

        //! A destructor
        ~PKey();

        EVP_PKEY *pkey_;/*!<openssl key*/
        vmp_bool free_;/*!<free ssl memory when destroy object*/
        
        //! Set key
        /*!
             @param pkey openssl key
             @param free free ssl memory when destroy object
             @sa pkey_
             @sa free_
        */
        void set(EVP_PKEY *pkey,vmp_bool free=true);
        
        //!Reset container
        void reset();

        //!Returns the key in string format
        /*!
            @return key.If error throw exception
        */
        vmp::str key_print();

        //!Returns key type
        /*!
            @return key type.If error throw exception
        */ 
        vmp::str type_str();
};

}}}

#endif

