/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 26/01/2020
 */

#ifndef VAMPIRIA_PYLIB_SIGNATURE_H

#define VAMPIRIA_PYLIB_SIGNATURE_H 1

namespace vampiria { 

#define VMP_PYLIB_MAX_DEFSTUBARITY 5
	
namespace pylib {

template<typename Sig>
struct Signature {};

template<typename Return,typename ... Args>
struct Signature<vmp::function<Return(*)(Args...)>>
{
      static constexpr vmp_size Arity_ = sizeof...(Args);
      typedef Return ret_t;
      typedef typename vmp::tuple_element<0,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg0_t;
      typedef typename vmp::tuple_element<1,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg1_t;
      typedef typename vmp::tuple_element<2,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg2_t;
      typedef typename vmp::tuple_element<3,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg3_t;
      typedef typename vmp::tuple_element<4,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg4_t;
      typedef ret_t (*fn0_t)();
      typedef ret_t (*fn1_t)(arg0_t);
      typedef ret_t (*fn2_t)(arg0_t,arg1_t);
      typedef ret_t (*fn3_t)(arg0_t,arg1_t,arg2_t);
      typedef ret_t (*fn4_t)(arg0_t,arg1_t,arg2_t,arg3_t);
      typedef ret_t (*fn5_t)(arg0_t,arg1_t,arg2_t,arg3_t,arg4_t);

      template<class Fn>
      static pylib::Objref *invoke(Fn &fn_,arg0_t arg0,arg1_t arg1,arg2_t arg2,arg3_t arg3,arg4_t arg4,vmp_bool retfree)
      {
           fn0_t fn0_c=reinterpret_cast<fn0_t>(fn_);
           fn1_t fn1_c=reinterpret_cast<fn1_t>(fn_);
           fn2_t fn2_c=reinterpret_cast<fn2_t>(fn_);
           fn3_t fn3_c=reinterpret_cast<fn3_t>(fn_);
           fn4_t fn4_c=reinterpret_cast<fn4_t>(fn_);
           fn5_t fn5_c=reinterpret_cast<fn5_t>(fn_);
           switch(Arity_)
           {
               case 0:return pylib::Converter<ret_t>(fn0_c(),retfree);
               case 1:return pylib::Converter<ret_t>(fn1_c(arg0),retfree);
               case 2:return pylib::Converter<ret_t>(fn2_c(arg0,arg1),retfree);
               case 3:return pylib::Converter<ret_t>(fn3_c(arg0,arg1,arg2),retfree);
               case 4:return pylib::Converter<ret_t>(fn4_c(arg0,arg1,arg2,arg3),retfree);
               case 5:return pylib::Converter<ret_t>(fn5_c(arg0,arg1,arg2,arg3,arg4),retfree);
           }
           return 0;     
      }
      
};

template<typename ... Args>
struct Signature<vmp::function<void(*)(Args...)>>
{
      static constexpr vmp_size Arity_ = sizeof...(Args);
      typedef typename vmp::tuple_element<0,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg0_t;
      typedef typename vmp::tuple_element<1,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg1_t;
      typedef typename vmp::tuple_element<2,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg2_t;
      typedef typename vmp::tuple_element<3,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg3_t;
      typedef typename vmp::tuple_element<4,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg4_t;
      typedef void (*fn0_t)();
      typedef void (*fn1_t)(arg0_t);
      typedef void (*fn2_t)(arg0_t,arg1_t);
      typedef void (*fn3_t)(arg0_t,arg1_t,arg2_t);
      typedef void (*fn4_t)(arg0_t,arg1_t,arg2_t,arg3_t);
      typedef void (*fn5_t)(arg0_t,arg1_t,arg2_t,arg3_t,arg4_t);

      template<class Fn>
      static pylib::Objref *invoke(Fn &fn_,arg0_t arg0,arg1_t arg1,arg2_t arg2,arg3_t arg3,arg4_t arg4,vmp_bool retfree)
      {
           fn0_t fn0_c=reinterpret_cast<fn0_t>(fn_);
           fn1_t fn1_c=reinterpret_cast<fn1_t>(fn_);
           fn2_t fn2_c=reinterpret_cast<fn2_t>(fn_);
           fn3_t fn3_c=reinterpret_cast<fn3_t>(fn_);
           fn4_t fn4_c=reinterpret_cast<fn4_t>(fn_);
           fn5_t fn5_c=reinterpret_cast<fn5_t>(fn_);
           switch(Arity_)
           {
               case 0:fn0_c();break;
               case 1:fn1_c(arg0);break;
               case 2:fn2_c(arg0,arg1);break;
               case 3:fn3_c(arg0,arg1,arg2);break;
               case 4:fn4_c(arg0,arg1,arg2,arg3);break;
               case 5:fn5_c(arg0,arg1,arg2,arg3,arg4);break;
               default:return 0;
           }
           return pylib::retnone();     
      }
};

template<typename W,typename Return,typename ... Args>
struct Signature<vmp::function<Return(W::*)(Args...)>>
{
      static constexpr vmp_size Arity_ = sizeof...(Args);
      typedef Return ret_t;
      typedef typename vmp::tuple_element<0,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg0_t;
      typedef typename vmp::tuple_element<1,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg1_t;
      typedef typename vmp::tuple_element<2,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg2_t;
      typedef typename vmp::tuple_element<3,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg3_t;
      typedef typename vmp::tuple_element<4,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg4_t;
      typedef ret_t (W::*fn0_t)();
      typedef ret_t (W::*fn1_t)(arg0_t);
      typedef ret_t (W::*fn2_t)(arg0_t,arg1_t);
      typedef ret_t (W::*fn3_t)(arg0_t,arg1_t,arg2_t);
      typedef ret_t (W::*fn4_t)(arg0_t,arg1_t,arg2_t,arg3_t);
      typedef ret_t (W::*fn5_t)(arg0_t,arg1_t,arg2_t,arg3_t,arg4_t);
      
      template<class Fn>
      static Objref *invoke(W *instance,Fn &fn_,arg0_t arg0,arg1_t arg1,arg2_t arg2,arg3_t arg3,arg4_t arg4,vmp_bool retfree)
      {
           fn0_t fn0_c=reinterpret_cast<fn0_t>(fn_);
           fn1_t fn1_c=reinterpret_cast<fn1_t>(fn_);
           fn2_t fn2_c=reinterpret_cast<fn2_t>(fn_);
           fn3_t fn3_c=reinterpret_cast<fn3_t>(fn_);
           fn4_t fn4_c=reinterpret_cast<fn4_t>(fn_);
           fn5_t fn5_c=reinterpret_cast<fn5_t>(fn_);
           switch(Arity_)
           {
               case 0:return pylib::Converter<ret_t>((instance->*fn0_c)(),retfree);
               case 1:return pylib::Converter<ret_t>((instance->*fn1_c)(arg0),retfree);
               case 2:return pylib::Converter<ret_t>((instance->*fn2_c)(arg0,arg1),retfree);
               case 3:return pylib::Converter<ret_t>((instance->*fn3_c)(arg0,arg1,arg2),retfree);
               case 4:return pylib::Converter<ret_t>((instance->*fn4_c)(arg0,arg1,arg2,arg3),retfree);
               case 5:return pylib::Converter<ret_t>((instance->*fn5_c)(arg0,arg1,arg2,arg3,arg4),retfree);
           }
           return 0;     
      }
};

template<typename W,typename ... Args>
struct Signature<vmp::function<void(W::*)(Args...)>>
{
      static constexpr vmp_size Arity_ = sizeof...(Args);
      typedef typename vmp::tuple_element<0,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg0_t;
      typedef typename vmp::tuple_element<1,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg1_t;
      typedef typename vmp::tuple_element<2,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg2_t;
      typedef typename vmp::tuple_element<3,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg3_t;
      typedef typename vmp::tuple_element<4,vmp::tuple<Args ...,void *,void *,void *,void *,void *>>::type arg4_t;
      typedef void (W::*fn0_t)();
      typedef void (W::*fn1_t)(arg0_t);
      typedef void (W::*fn2_t)(arg0_t,arg1_t);
      typedef void (W::*fn3_t)(arg0_t,arg1_t,arg2_t);
      typedef void (W::*fn4_t)(arg0_t,arg1_t,arg2_t,arg3_t);
      typedef void (W::*fn5_t)(arg0_t,arg1_t,arg2_t,arg3_t,arg4_t);
      
      template<class Fn>
      static Objref *invoke(W *instance,Fn &fn_,arg0_t arg0,arg1_t arg1,arg2_t arg2,arg3_t arg3,arg4_t arg4,vmp_bool retfree)
      {
           fn0_t fn0_c=reinterpret_cast<fn0_t>(fn_);
           fn1_t fn1_c=reinterpret_cast<fn1_t>(fn_);
           fn2_t fn2_c=reinterpret_cast<fn2_t>(fn_);
           fn3_t fn3_c=reinterpret_cast<fn3_t>(fn_);
           fn4_t fn4_c=reinterpret_cast<fn4_t>(fn_);
           fn5_t fn5_c=reinterpret_cast<fn5_t>(fn_);
           switch(Arity_)
           {
               case 0:(instance->*fn0_c)();break;
               case 1:(instance->*fn1_c)(arg0);break;
               case 2:(instance->*fn2_c)(arg0,arg1);break;
               case 3:(instance->*fn3_c)(arg0,arg1,arg2);break;
               case 4:(instance->*fn4_c)(arg0,arg1,arg2,arg3);break;
               case 5:(instance->*fn5_c)(arg0,arg1,arg2,arg3,arg4);break;
               default:return 0;
           }
           return pylib::retnone();     
      }
};

}}

#endif

