/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */

#ifndef VAMPIRIA_PACKET_IP_H

#define VAMPIRIA_PACKET_IP_H 1

namespace vampiria { namespace packet {

//! Header ipv4
class Ipv4_P:public packet::Packet
{
    private:
        //! Internal usage
        void checksum_set();
    public:
        //! A constructor
        Ipv4_P();

        //! A destructor
        ~Ipv4_P();

        //! Virtual function
        void read(vmp::Buf *buf);
        
        //! Virtual function
        void set(vmp::str field,vmp::str data);
        
        //! Virtual function
        vmp::str next_type();

        //! Virtual function
        void pseudo_header(vmp::Buf *buf);
        
        //! Check integrity header
        vmp_bool integrity_check();
};

}}

#endif

