/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/11/2020
 */

#ifndef VAMPIRIA_PACKET_BITWISE_H

#define VAMPIRIA_PACKET_BITWISE_H 1

namespace vampiria { namespace packet {

//! Data size in biwise format
class BitSize:public packet::Bitwise
{
    public:
        //! A constructor
        /*!
            @param field data filed
            @param init initial bit where the data in DataBytes are found
            @param size number of data bits
        */
        BitSize(vmp::str field,vmp_byte init,vmp_byte size);

        //! A destructor
        ~BitSize();

        //! Virtual function
        vmp::str get(vmp_size data);

        //! Virtual function
        vmp_size set(vmp::str data);
};

//! Data size in biwise format(hexadecimal mode)
class BitHexSize:public packet::Bitwise
{
    public:
        //! A constructor
        /*!
            @param field data filed
            @param init initial bit where the data in DataBytes are found
            @param size number of data bits
        */
        BitHexSize(vmp::str field,vmp_byte init,vmp_byte size);

        //! A destructor
        ~BitHexSize();

        //! Virtual function
        vmp::str get(vmp_size data);

        //! Virtual function
        vmp_size set(vmp::str data);
};

//!Selection data with numeric value in bitwise
class BitSelect:public packet::Bitwise
{
    private:
        vmp::Table<vmp_size,vmp::str> code_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp_size> name_;/*!<Internal usage*/
    public:
        //! A constructor
        /*!
            @param field data filed
            @param init initial bit where the data in DataBytes are found
            @param size number of data bits
        */ 
        BitSelect(vmp::str field,vmp_byte init,vmp_byte size);
        
        //! A destructor
        ~BitSelect();

        //! Virtual function
        vmp::str get(vmp_size data);
        
        //! Virtual function
        vmp_size set(vmp::str data);

        //! Insert selectable data
        /*!
            @param name data name
            @param code data code(The maximum acceptable value of the code depends on the size set in the constructor)
            @return void or except to mistake
        */
        void insert_code(vmp::str name,vmp_size code);
};

}}

#endif

