/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 16/05/2020
 */

#ifndef VAMPIRIA_EVENT_THREADUI_H

#define VAMPIRIA_EVENT_THREADUI_H 1

namespace vampiria { namespace event {

//!Event used by threadui
class ThreadRef:public event::EventThread
{
    public:
        //! A Constructor
        ThreadRef();

        //! A Destructor
        ~ThreadRef();

        vmp::str id_;/*!<Event id*/
};

//!Thread User interface
class ThreadUI:public event::UI
{
    private:
        vmp::utils::Storage<ThreadRef> tref_;/*!<Storage event*/
        event::EVTCB revent_;/*!<Callback performed by the thread*/
        event::EVTCB cancel_;/*!<Callback performed by the cancel exec*/
        event::EVTCB cevent_;/*!<Callback close event*/ 
    public:
        //!A Constructor
        /*!
            @param manager input manager
        */
        ThreadUI(event::Manager *manager);
        
        //! A Destructor
        ~ThreadUI();

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);

        //!Set Thread event
        /*!
            @param revent Callback performed by the thread
            @param cancel Callback performed by the cancel exec(default pthread_cancel)
            @param cevent close event callback 
        */
        void set_event(event::EVTCB run,event::EVTCB cancel,event::EVTCB cevent);
        
        //! Create new thread event
        /*!
            @param id id event
            @return cell associated with event(except error)
        */
        event::Cell *new_thread(vmp::str id);
        
        //!Returns id event
        /*!
            @param cell cell associated
            @return id event
        */
        vmp::str id(event::Cell *cell);
};

}}

#endif

