/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 16/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

ThreadRef::ThreadRef():event::EventThread()
{
}

ThreadRef::~ThreadRef()
{
}

ThreadUI::ThreadUI(event::Manager *manager):event::UI(manager)
{
    set_event(0,0,0);
}
        
ThreadUI::~ThreadUI()
{
}

vmp::str ThreadUI::identity(event::Cell *cell)
{
    vmp::str ret;
    ThreadRef *tevent=cell->event<ThreadRef>();
    vmp::unicode::str_write(&ret,"Thread event [id=%s]",tevent->id_.c_str());
    return ret;
}
        
void ThreadUI::close_event(event::Cell *cell)
{
    ThreadRef *tevent=cell->event<ThreadRef>();
    tevent->evt_thread_close();
}

void ThreadUI::free_ref(event::Cell *cell)
{
    ThreadRef *tevent=cell->event<ThreadRef>();
    tevent->evt_thread_free();
    tevent->id_="";
    tref_.free(tevent);
}

void ThreadUI::set_event(event::EVTCB revent,event::EVTCB cancel,event::EVTCB cevent)
{
    revent_=revent;
    cancel_=cancel;
    cevent_=cevent;
}
event::Cell *ThreadUI::new_thread(vmp::str id)
{
    event::Cell *cell=0;
    manager_->lock();
    ThreadRef *tevent=tref_.get();
    try
    {
        cell=tevent->evt_thread_new(this,revent_,cancel_,cevent_);
        tevent->id_=id;
    }
    catch(vmp::exception &x)
    {
        tref_.free(tevent);
        manager_->unlock();
        vmp::except_s(x.what()); 
    }
    manager_->unlock();
    return cell;
}

vmp::str ThreadUI::id(event::Cell *cell)
{
    ThreadRef *tevent=cell->event<ThreadRef>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str id=tevent->id_;
    manager->unlock();
    return id;
}

}}

