/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_INPUTUI_H

#define VAMPIRIA_EVENT_INPUTUI_H 1

namespace vampiria { namespace event {

//!Input User interface
class InputUI:public event::UI
{
    private:
        event::EventInput evinput_;/*!<Event associated*/
        event::Cell *cell_;/*!<Cell references*/
        EVTCBSTR ievent_;/*!<Input callback*/
        EVTCB cevent_;/*!<Close callback*/

    public:
        //!A Constructor
        /*!
            @param manager input manager
        */
        InputUI(Manager *manager);
        
        //!A Destructor
        ~InputUI();

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);

        //!Set Input event
        /*!
            @param ievent input event callback
            @param cevent close event callback 
        */
        void set_event(event::EVTCBSTR ievent,event::EVTCB cevent);

        //!Create input event(only a wind is allowed)
        /*!
             @return cell associated with event(except error)
        */
        Cell *input();
};

}}

#endif

