/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/04/2020
 */

#include "event.h"

namespace vampiria { namespace event {

void empty_ev(event::Cell *cell)
{
}

void empty_str_ev(event::Cell *cell,vmp::str data)
{
}

Event::Event()
{
    priority_=0;
    fd_=-1;
    cell_=0;
}
        
Event::~Event()
{
}

void Event::set_priority(vmp_int priority)
{
    if(priority < event::MAX_CELL_PRIORITY)
       priority_=priority;
    else
       priority_=event::MAX_CELL_PRIORITY;
}

event::Cell *Event::evt_new(event::UI *ui,vmp_int fd,event::EVTCB read,event::EVTCB close)
{
   vmp::except_check_pointer((void *)ui,"event::Event::evt_new() null input ui");
   fd_=fd;
   if(fd_ >= 0)
     vmp::fd_noblock(fd_);
   active_=true;
   return ui->manager()->cell_new(ui,this,priority_,read,close);
}

void Event::evt_active(vmp_bool active)
{
   active_=active;
   cell_->get_manager()->breakloop();
}

void Event::evt_close()
{
}

void Event::evt_free()
{
   priority_=0;
   fd_=-1;
   cell_=0;
}

EventPipe::EventPipe():Event()
{
   wfd_=-1;
}
       
EventPipe::~EventPipe()
{
}

event::Cell *EventPipe::evt_pipe_new(event::UI *ui,event::EVTCB read,event::EVTCB close)
{
   vmp_int fdr;
   try
   {
      vmp::pipe_wrap(&fdr,&wfd_);
   }
   catch(vmp::exception &x)
   {
      vmp::except("event::EvtPipe::evt_pipe_new() error '%s'",x.what());
   }
   return evt_new(ui,fdr,read,close);
}

void EventPipe::evt_pipe_closew()
{
    vmp::fd_close(&wfd_);
}

void EventPipe::evt_pipe_close()
{
    vmp::fd_close(&wfd_);
    vmp::fd_close(&fd_);
    evt_close();
}
       
void EventPipe::evt_pipe_free()
{
    wfd_=-1;
    evt_free();
}

}}



