#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 26/11/2020

import vmp_plugin.base as base

ptype_="format"
format_f_="format"
rformat_f_="rformat"
format_list_f_="format_list"
rformat_list_f_="rformat_list"
format_str_tolist_f_="format_str_tolist"
rformat_str_tolist_f_="rformat_str_tolist"
format_list_tostr_f_="format_list_tostr"
rformat_list_tostr_f_="rformat_list_tostr"

##Plugin interface used for string operation.
class Plugin(base.Plugin):
  def __init__(self,data,options):
    base.Plugin.__init__(self,ptype_,data,0,options)
  
  ##Takes a string as input and returns a string
  def format(self,strinput):
    self.not_implemented(format_f_)

  ##Takes a string as input and returns a string(reverse operation)
  def rformat(self,strinput):
    self.not_implemented(rformat_f_)

  ##Takes as input a list of strings and returns a list of strings
  def format_list(self,strlist):
    self.not_implemented(format_list_f_)

  ##Takes as input a list of strings and returns a list of strings(reverse operation)
  def rformat_list(self,strlist):
    self.not_implemented(rformat_list_f_)

  ##Takes a string as input and returns a list of strings
  def format_str_tolist(self,strinput):
    self.not_implemented(format_str_tolist_f_)

  ##Takes a string as input and returns a list of strings(reverse operation)
  def rformat_str_tolist(self,strinput):
    self.not_implemented(rformat_str_tolist_f_)

  ##Takes as input a list of strings and returns a string
  def format_list_tostr(self,strlist):
    self.not_implemented(format_list_tostr_f_)

  ##Takes as input a list of strings and returns a string(reverse operation)
  def rformat_list_tostr(self,strlist):
    self.not_implemented(rformat_list_tostr_f_)

##Plugin interface topic
class PluginTopic(base.PluginTopic):
  def __init__(self,modname,plugname):
    base.PluginTopic.__init__(self,ptype_,modname,plugname)
    self.set_desc("Plugin interface used for string operation")
    self.add_function(format_f_,"Takes a string as input and returns a string(not implemented)")
    self.add_function(rformat_f_,"Takes a string as input and returns a string(reverse operation)(not implemented)")
    self.add_function(format_list_f_,"Takes as input a list of strings and returns a list of strings(not implemented)")
    self.add_function(rformat_list_f_,"Takes as input a list of strings and returns a list of strings(reverse operation)(not implemented)")
    self.add_function(format_str_tolist_f_,"Takes a string as input and returns a list of strings(not implemented)")
    self.add_function(rformat_str_tolist_f_,"Takes a string as input and returns a list of strings(reverse operation)(not implemented)")
    self.add_function(format_list_tostr_f_,"Takes as input a list of strings and returns a string(not implemented)")
    self.add_function(rformat_list_tostr_f_,"Takes as input a list of strings and returns a string(reverse operation)(not implemented)")

