/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 27/02/2020
 */

#include "net_.h"

void net_init(pylib::Module module)
{
    //net/address.h
    module.def_("is_ipv4_raw",net::is_ipv4_raw);
    module.def_("is_ipv6_raw",net::is_ipv6_raw);
    module.def_("ip_to_buf",net::ip_to_buf);
    module.def_("ipv4_from_buf",net::ipv4_from_buf);
    module.def_("ipv6_from_buf",net::ipv6_from_buf);
    module.def_("is_macaddress_raw",net::is_macaddress_raw);
    module.def_("macaddress_to_buf",net::macaddress_to_buf);
    module.def_("macaddress_from_buf",net::macaddress_from_buf);
}

VAMPIRIA_PYLIB_INIT(vmp_net_);

void vampiria_pylib_init_module(pylib::Module init_module)
{
    net_init(init_module);
    net_init_address(init_module);
    net_init_netdevice(init_module);
    net_init_macaddress(init_module);
    net_init_udp(init_module);
    net_init_udpui(init_module);
    net_init_tcp(init_module);
    net_init_tcpui(init_module);
}

