#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 15/07/2018

import vmpsys    as sys
import vmpconfig as config

##Check python version
def pyversion():
  pyversion=sys.pyversion()  
  if pyversion >= config.pyversion_:
    sys.msg_ok("Python {0}".format(pyversion))
  else:
    sys.msg_failure("Python {0}".format(pyversion),"is not >= {0}".format(config.pyversion_))

##Check python clear command
def pyclean():
  sys.search_cmd(config.pyclean_check_)
 
##Test pyrun main<BR>
#
#@param name library name
def pylibtest(name): 
  libname=name
  sys.module_import(libname)

##Test pyrun main<BR>
def pyruntest(): 
  try:
    sys.main_def()
  except Exception as e:
    raise e

##Check compiler utility command
def compiler():
  if sys.search_cmd(config.cpp_help_) and sys.search_cmd(config.cpphdr_help_) and sys.search_cmd(config.pkgconfig_help_):
     sys.msg_ok("Compiler check")
     
##Check if cpp header files is installed in the system<BR>
#
#@param hdr header file name
def header(hdr):
  hpath=config.cpphdr_cmd_(hdr)
  if sys.system(hpath) is 0:
    sys.msg_ok("Check Header \'{0}\'".format(hdr))
  else:
    sys.msg_failure("Check Header \'{0}\'".format(hdr),"not found")

##Check if library is installed in the system<BR>
#
#@param lib library name<BR>
#@param version minimum library version
def lib(lib,version):
  cmd="pkg-config --cflags --libs \"{0} >= {1}\" > /dev/null 2>&1".format(lib,version)
  if sys.system(cmd) is 0:
    sys.msg_ok("Check Lib \'{0} >= {1}\'".format(lib,version))
  else:
    sys.msg_failure("Check Lib \'{0} >= {1}\'".format(lib,version),"not found")

##Check if software is installed in dirpath<BR>
#
#@param dirpath absolute software path<BR>
#@return true is installed, otherwise false
def check_installed(dirpath):
  if not sys.isdir(dirpath):
    raise ValueError("Not Found")
  installed=config.ginstalled_(dirpath)
  if sys.isfile(installed):
    return True
  return False

##Check the installation status of the software<BR>
#
#@param softpath absolute directory software<BR>
#@return string "Installed". otherwise raise "Not Installed" or "Not Found"
def software_install_status(softpath):
  if check_installed(softpath):
    return "Installed"
  return "Not Installed"

##Check the installation status of the module<BR>
#
#@param modpath absolute directory module<BR>
#@return string "Installed","Not Installed" or raise "Not Found" or "Manifest Not found"
def module_install_status(modpath):
  manifest="{0}{1}".format(modpath,config.gmodulemanifest_)
  if not sys.isfile(manifest):
    raise ValueError("Manifest Not Found")   
  return software_install_status(modpath) 

##Check software required and optional<BR>
#
#@param req required software<BR>
#@param opt optional sofoware
def check_software(req,opt):
  if not (len(req) == 0):
    sys.stdout("\nRequired Software:\n")
    for s in req:
      try:
        sys.stdout("\t{0} [{1}]\n".format(s,software_install_status(sys.path(config.gsoftware_path(s)))))
      except Exception as e:
        sys.stdout("\t{0} [{1}]\n".format(s,str(e)))
  if not (len(opt) == 0):
    sys.stdout("\nOptional software:\n")
    for s in opt:
      try:
        sys.stdout("\t{0} [{1}]\n".format(s,software_install_status(sys.path(config.gsoftware_path(s)))))
      except Exception as e:
        sys.stdout("\t{0} [{1}]\n".format(s,str(e)))

##Check modules required and optional<BR>
#
#@param req required modules<BR>
#@param opt optional modules
def check_modules(req,opt):
  spath=sys.path(config.gmodules_)
  if not (len(req) == 0):
    sys.stdout("\nRequired Modules:\n")
    for s in req:
      try:
        sys.stdout("\t{0} [{1}]\n".format(s,module_install_status(sys.path(config.gmodule_main_(s)))))
      except Exception as e:
        sys.stdout("\t{0} [{1}]\n".format(s,str(e)))
  if not (len(opt) == 0): 
    sys.stdout("\nOptional Modules:\n")
    for s in opt: 
      try:
        sys.stdout("\t{0} [{1}]\n".format(s,module_install_status(sys.path(config.gmodule_main_(s)))))
      except Exception as e:
        sys.stdout("\t{0} [{1}]\n".format(s,str(e)))

