#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 11/12/2018

import vmpsys    as sys
import vmputils  as utils
import vmpconfig as config
import vmpcheck  as check

config.pyenv()

import vpkg

##Print software list
def software_list():
  sys.stdout("Software List:\n");
  lst=sys.listdir(sys.path(config.gsoftware_))
  for l in lst:
    sys.stdout("{0} [{1}]\n".format(l,check.software_install_status(sys.path(config.gsoftware_path(l)))))

##Description  software
def software_desc(dirpath):
  if not sys.isdir(dirpath):
    raise ValueError("Not Found")
  try:
    return sys.setup_import().description()
  except Exception as e:
    raise ValueError(e)
    
##Install a software<BR>
#
#dirpath absolute directory software
def software_install(dirpath):
  if not sys.isdir(dirpath):
    return False
  try:
    sys.setup_import().install()
    sys.write_file(config.ginstalled_(dirpath),'')
  except Exception as e:
    raise ValueError(e)
  return True

##Print module list
def modules_list():
  sys.stdout("Modules List:\n");
  lst=sys.listdir(sys.path(config.gmodules_))
  for l in lst:
    try:
      sys.stdout("{0} [{1}]\n".format(l,check.module_install_status(sys.path(config.gmodule_main_(l)))))
    except Exception as e:
      pass

##Install a module<BR>
#
#@param name module name<BR>
def module_install(name):
  try:
    pname=sys.path(config.gmodule_main_(name))
    check.module_install_status(pname) 
    if not software_install(pname):
      return False
    m=sys.module_import(name,config.gmoduleimp_)
  except Exception as e:
    raise ValueError(e)
  return True

##Install a doc<BR>
#
#@param docsrc doxygen.conf path<BR>
#@param docout documentation out<BR>
#@param msg    message print    
def doc_install(docsrc,docout,msg):
  if sys.search_cmd(['doxygen','-v']):
    local=sys.getcwd()
    sys.chdir(sys.path(docsrc))
    sys.system("doxygen doxygen.conf")
    sys.chdir(local)
    sys.msg_ok("Install doc {0} in [{1}]".format(msg,docout))

help_=[
       ("To Install vampiria software:","-s {name}"),
       ("To Get software list:","-sl"),
       ("To Get software description:","-sd {name}"),
       ("To Install module usage:","-m {name}"),
       ("To Get modules list:","-ml"),
       ("To Get module description:","-md {name}"),
       ("To install framework main doc","-dm"),
       ("To Install framework c++ doc","-dc"),
       ("To Install framework python doc","-dp"),
       ("To Install package c++ doc","-dk"),
       ("To Install package python doc","-dv")
      ]

if __name__ == "__main__":
  args=sys.argv_get()
  l=len(args)
  if l == 1:
    if args[0] == '-sl':
      software_list()
      sys.exit_ok()
    elif args[0] == '-ml':
      modules_list()
      sys.exit_ok()
    elif args[0] == '-dc':
      doc_install(config.fwsrc_,"{0}C++".format(config.fwdoc_),"Vampiria framework C++ library")
      sys.exit_ok()
    elif args[0] == '-dp':
      doc_install(config.fwpylib_,"{0}python".format(config.fwdoc_),"Vampiria framework Python library")
      sys.exit_ok()      
    elif args[0] == '-dm':
      doc_install(config.fwmain_,"{0}main".format(config.fwdoc_),"Vampiria framework main library")
      sys.exit_ok()
    elif args[0] == '-dk':
      doc_install(config.gpkg_,"{0}pkg".format(config.fwdoc_),"Vampiria package C++")
      sys.exit_ok()
    elif args[0] == '-dv':
      doc_install(config.gvpkg_,"{0}vpkg".format(config.fwdoc_),"Vampiria package python")
      sys.exit_ok()
  elif l == 2:
    check.pyversion()
    check.compiler()
    check.pyclean()
    if args[0] == '-s':
      config.pyhome_add(config.gsoftware_path(args[1]))
      try:
        if software_install(sys.path(config.gsoftware_path(args[1]))):
          sys.msg_ok("Software install \'{0}\'".format(args[1])) 
          sys.exit_ok()
        else:
          sys.msg_failure("Install Software \'{0}\'".format(args[1]),"Not Found")
      except Exception as e:
          sys.msg_failure("Install Software \'{0}\'".format(args[1]),str(e))
    elif args[0] == '-sd':
      config.pyhome_add(config.gsoftware_path(args[1]))
      try:
        desc=software_desc(config.gsoftware_path(args[1]))
        sys.stdout("Software \'{0}\' description:\n{1}\n".format(args[1],desc))
        sys.exit_ok()
      except Exception as e:
        sys.msg_failure("Software description \'{0}\'".format(args[1]),str(e))
    elif args[0] == '-m':
      try:
        config.pyhome_add(config.gmodule_main_(args[1]))
        if module_install(args[1]):
          sys.msg_ok("Module install \'{0}\'".format(args[1]))
          sys.exit_ok()
        else:
          sys.msg_failure("Install Module \'{0}\'".format(args[1]),"Not Found")
      except Exception as e:
        sys.msg_failure("Install Module \'{0}\'".format(args[1]),str(e))
    elif args[0] == '-md':
      config.pyhome_add(config.gmodule_main_(args[1]))
      try:
        desc=software_desc(config.gmodule_main_(args[1]))
        sys.stdout("Module \'{0}\' description:\n{1}\n".format(args[1],desc))
        sys.exit_ok()
      except Exception as e:
        sys.msg_failure("Module description \'{0}\'".format(args[1]),str(e))
  utils.help(config.installer_,help_)

