/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/02/2020
 */

#include "vmp.h"
#include "process.h"

//insert software name
vmp::str id_="example_py";

vmp::str usage()
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"%s",id_.c_str());
    return ret;
}

vmp_int main(vmp_int argc,vmp_char *argv[],vmp_char *envp[])
{
    vmp::init(id_,true);
    if(argc != 1)
        vmp::exit_failure("Invalid input arguments!!!\n%s",usage().c_str());
    vmp::str path;
    vmp::unicode::str_write(&path,"%s%s",VSOFTWARE,id_.c_str());
    vmp::args::Envp env(envp);
    try 
    {
        process::Pyexec exec(path,id_,true,env);
        exec.run();
    }
    catch(std::exception& e) 
    {
        vmp::exit_failure("%s",e.what());
    }
    vmp::exit_ok();
    return 0;
}


