# -*- coding: utf-8 -*-

#!/usr/bin/env python
#author Marco Guastella alias Vasta

import sys

try:
   import gtk
except:
    print 'required gtk'
    sys.exit(-1)

try:
   import gtk.glade
except:
   print 'required gtk.glade'
   sys.exit(-1)

try:
    import pygtk
    pygtk.require("2.0")
    
except:
    print 'required pygtk 2.0'
    sys.exit(-1)

import subprocess
import os

class about:
	
	def __init__(self):
		self.uboot=gtk.glade.XML("src/uboot.glade")
		self.about = self.uboot.get_widget('info')
		dic={"on_about_destroy":self.close,
			  "on_info_response":self.close,
		}
		self.uboot.signal_autoconnect(dic)
		self.about.show()
		
	def close(self,response,widget):
		self.about.destroy()
		del self
		
class confirm:

	def __init__(self,com,fan,fok,t):
		self.msg = gtk.glade.XML("src/uboot.glade")
		self.win = self.msg.get_widget('confirm')
		self.win.format_secondary_text(com)
		self.an = fan
		self.ok = fok
		self.tx=t
		dic={"on_confirm_response":self.on_confirm_response ,
			}
	
		self.msg.signal_autoconnect(dic)
		self.win.show()
		
		
	def on_confirm_response(self,dialog,response_id):
		self.win.destroy()
		if response_id == gtk.RESPONSE_NO:
			self.an()
		else:
			proc = subprocess.Popen("apt-get -y remove " + self.tx,shell=True)
			os.waitpid(proc.pid, 0)
			self.ok()
		
class window:
	
	def __init__(self):
		self.uboot=gtk.glade.XML("src/uboot.glade")
		self.win = self.uboot.get_widget('window')
		self.klabel = self.uboot.get_widget('klabel')
		self.slabel = self.uboot.get_widget('slabel')
		self.fbox = self.uboot.get_widget('fbox')
		self.remove = self.uboot.get_widget('remove')
		self.bg = gtk.gdk.Color("white")
		self.win.modify_bg(gtk.STATE_NORMAL,self.bg)
		self.combo = gtk.combo_box_new_text()
		self.combo.show()
		self.fbox.pack_start(self.combo)
		
		dic={"on_window_destroy":gtk.main_quit,
			 "on_quit_activate":gtk.main_quit,
			 "on_about_activate":self.onabout,
			 "on_remove_clicked":self.onremoveclicked
		}
		self.uboot.signal_autoconnect(dic)
		self.kdict = {}
		self.current = self.currentkernel()
		self.kernellist()
		self.updatelabel()
		self.win.show()
		gtk.main()
		
	def  onabout(self,widget):
		about()
		
	def onremoveclicked(self,widget):
		self.tx = self.combo.get_active_text()
		if self.tx != None:
			self.confirm =confirm("Do you want remove " + self.tx + "?\n",self.confirmno,self.confirmok,self.tx)
			
	def confirmok(self):
		del self.confirm
		print('removed ' + self.tx)
		self.resetCombo()
		self.kernellist()
		self.updatelabel()
	
	def confirmno(self):
		del self.confirm
		
	def currentkernel(self):
		proc = subprocess.Popen("uname -r",shell=True,stdin=subprocess.PIPE,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
		ckernel=proc.communicate()[0]
		return ckernel.rstrip('\n')
		
	def kernellist(self):
		k = self.kdict.keys()
		for val in k:
			del self.kdict[val]
		proc = subprocess.Popen("ls /boot/vmlinuz*",shell=True,stdin=subprocess.PIPE,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
		out=proc.communicate()[0]
		lout=out.split('\n')
		for val in lout:
			if val != '':
				if val[14:] == self.current :
					self.kdict[val[14:]] = "current"
				else:
					self.kdict[val[14:]] = "available"
		
	def updatelabel(self):
		kl = 'KERNEL IMAGE:\n\n'
		ks = 'STATUS:\n\n'
		k = self.kdict.keys()
		k.sort()
		for val in k:
			kl = kl + "linux-image-" + val + "     \n\n"
			ks= ks + self.kdict[val] + "     \n\n"
			if self.kdict[val] == 'available':
				self.combo.append_text("linux-image-"+val)
		self.klabel.set_text(kl)
		self.slabel.set_text(ks)
		
	def resetCombo(self):
		k = self.kdict.keys()
		for val in k:
			self.combo.remove_text(0)
	
if __name__ == "__main__":
	window()
	