#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>


declare VAR=$(zenity --entry --title="nslookup search" --text="insert domain name or ip address:")

if [  "$VAR"  != "" ]
then
	(
		echo "0"
		declare RESULT=$(nslookup $VAR)
		echo "100"
		zenity --info --title="nslookup result" --text="$RESULT" 
	) | zenity --progress  --title="nslookup gui" --text="Running nslookup..."  --percentage=0 --auto-close
	exit
fi
exit 



