#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>

declare VAL=$(zenity --list --radiolist --title="mount gui" --text="select mount type" --column="select" --column="type"  \
			true disk \
			false smbfs \
			false smbfs_auth \
			false nfs )
case $VAL in
			disk) declare DEV=$(zenity --entry  --title="mount gui" --text="insert device(ex sda1):")
				if [ "$DEV" = "" ]
				then
					exit
				fi
				declare DIR="/mnt/disk-$DEV"
				if   `mkdir $DIR` &> /dev/null 
				then
					DEV="/dev/$DEV" 
					mount $DEV $DIR
					thunar $DIR
					umount $DIR
					rmdir $DIR
				fi
				;;
			smbfs)declare HOST=$(zenity --entry  --title="mount gui" --text="insert remote host")
				   if [ "$HOST" = "" ]
				   then
					exit
				   fi
				  declare SHARED=$(zenity --entry  --title="mount gui" --text="insert shared directory")
				   if [ "$SHARED" = "" ]
				   then
					exit
				   fi
				   declare DIR="/mnt/smbfs-$HOST-$SHARED"
				   if   `mkdir $DIR` &> /dev/null 
				   then
						mount -t smbfs "//$HOST/$SHARED" $DIR  -o username=nobody,password= 
						thunar $DIR
						umount $DIR
						rmdir $DIR
				   fi
				  ;;
			smbfs_auth)declare HOST=$(zenity --entry  --title="mount gui" --text="insert remote host")
				   if [ "$HOST" = "" ]
				   then
					exit
				   fi
				   declare SHARED=$(zenity --entry  --title="mount gui" --text="insert shared directory")
				   if [ "$SHARED" = "" ]
				   then
					exit
				   fi
				   declare USER=$(zenity --entry  --title="mount gui" --text="insert username")
				   if [ "$USER" = "" ]
				   then
					exit
				   fi
				   declare PASSWORD=$(zenity --entry  --title="mount gui" --text="insert password" --hide-text)
				   if [ "$PASSWORD" = "" ]
				   then
					exit
				   fi 
				   declare DIR="/mnt/smbfs-$HOST-$SHARED"
				   if   `mkdir $DIR` &> /dev/null 
				   then
						mount -t smbfs "//$HOST/$SHARED" $DIR  -o username=$USER,password=$PASSWORD 
						thunar $DIR
						umount $DIR
						rmdir $DIR
				   fi
				   ;;
			nfs)  declare HOST=$(zenity --entry  --title="mount gui" --text="insert remote host")
				if [ "$HOST" = "" ]
				then
					exit
				fi
				declare DIRECTORY=$(zenity --entry  --title="mount gui" --text="insert remote directory")
				if [ "$DIRECTORY" = "" ]
				then
					exit
				fi
				declare DIR="/mnt/nfs-$HOST-$DIRECTORY"
				if   `mkdir $DIR` &> /dev/null 
				then
						mount -t nfs $HOST:$DIRECTORY $DIR 
						thunar $DIR
						umount $DIR
						rmdir $DIR
				   fi
				;;
			
esac
rmdir $DIR &>/dev/null 