#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>


declare db
declare ip
declare pass
declare out
declare i=0
declare ftp
declare ssh
declare http
declare tmp

while [ 1 ]
do
	out="/tmp/rtorscan$i"
	if [ ! -e $out ]
	then
		touch $out
		break;
	else
		i=$(expr $i + 1)
	fi
done

declare RESULT=$(zenity --list --radiolist --title="scan1 gui" --text="database" --column="select" --column="mode" \
				    TRUE open   \
				    FALSE create )
if [ "$RESULT" = "open" ]
then 
	db=$(zenity --file-selection  --title="select database")
elif [ "$RESULT" = "create" ]
then
	RESULT=$(zenity --file-selection  --title="select directory to create database" --directory)
	db=$(zenity --entry --title="scan1 gui" --text="insert database name:")
	db="$RESULT/$db.db"
	rm $db &>/dev/null
	sqlite3 $db "create table scan(ip text NOT NULL,protocol text NOT NULL,info text NOT NULL,PRIMARY KEY(ip,protocol));\
			  CREATE INDEX IDX_SCAN_PORT on scan(protocol);" &>/dev/null
else
	rm $out &>/dev/null
	exit 0
fi

while [ 1 ]
do
	#query or scan
	RESULT=$(zenity --list --radiolist --title="scan1 gui" --text="select operation" --column="select" --column="operation" \
				    TRUE Query   \
				    FALSE Scan )
	if [ "$RESULT" = "Query" ]
	then
		RESULT=$(zenity --list --radiolist --title="scan1 gui" --text="select service" --column="select" --column="service" \
			     TRUE ftp \
			     FALSE  ssh \
			     FALSE http)
		sqlite3 -line $db  "select  ip,info from scan where protocol=\"$RESULT\"" &>$out
		zenity --text-info --title="torscan gui query $RESULT" --filename=$out
	elif [ "$RESULT" = "Scan" ]
	then
		if [ $? = 0  ]
		then
			RESULT=$(zenity --file-selection  --title="select ip list file")
			(
				echo "0"
				echo "# expand ip address..."
				ip=$(riprange $RESULT 2>/dev/null)
				echo "# running scan"
				i=0;
				for line in $ip
				do
					echo "# ftp scan address:$line"
					ftp=$(proxychains rftpscan $line  2>/dev/null)
					echo "# ssh scan address:$line"
					ssh=$(proxychains rtcpscan $line 22 2>/dev/null)
					echo "# http scan address:$line"
					http=$(proxychains rhttpopt -h $line  2>/dev/null)
					echo "# $line:write data"
					j=$(expr 0)
					tmp=""
					for word in $ftp
					do
						if [ $j -lt 2 ]
						then
							j=$(expr $j + 1)
						else
							tmp="$tmp $word"
						fi
					done
					if [ "$tmp" != "" ]
					then
						sqlite3 $db "replace into scan values(\"$line\",\"ftp\",\"$tmp\")" &>/dev/null;
					fi
					j=$(expr 0)
					tmp=""
					for word in $ssh
					do
						if [ $j -lt 2 ]
						then
							j=$(expr $j + 1)
						else
							tmp="$tmp $word"
						fi
					done
					if [ "$tmp" != "" ]
					then
						sqlite3 $db "replace into scan values(\"$line\",\"ssh\",\"$tmp\")" &>/dev/null;
					fi
					j=$(expr 0)
					tmp=""
					for word in $http
					do
						if [ $j -lt 2 ]
						then
							j=$(expr $j + 1)
						else
							tmp="$tmp $word"
						fi
					done
					if [ "$tmp" != "" ]
					then
						sqlite3 $db "replace into scan values(\"$line\",\"http\",\"$tmp\")" &>/dev/null;
					fi
					i=$(expr $i + 1)
				done
				echo "100"
			) | zenity --progress  --title="torscan gui"   --text="Scan init" --percentage=0 --pulsate --auto-close --auto-kill
		else
			RESULT=$(cat $out)
			zenity --error --title="torscan gui" --text="tor control:$RESULT"
		fi
	else
		break;
	fi
done

rm $out &>/dev/null
exit 0

