#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>

declare FILE=$(cat /proc/net/dev)
declare VAL
declare NUM=0
declare INTERFACE
for LINE in $FILE
do
	VAL=$(echo $LINE | sed  -n  {s/:.*//p})
	if [ "$VAL" != ""  ] && [ "$VAL" != "lo" ]
	then	
		if [ $NUM = 0 ]
		then
			NUM=1
			INTERFACE="true $VAL " 
		else
			INTERFACE="$INTERFACE false $VAL "
		fi
	fi
done

if [ $NUM -ge 1 ]
then
	VAL=$(zenity --list --radiolist --title="rscanlan gui" --text="select interface" --column="select" --column="interface"  $INTERFACE)
	if [ "$VAL" = "" ] 
	then
		exit
	fi	
	declare MODE=$(zenity --list --radiolist --title="rscanlan gui" --text="select mode" --column="select" --column="mode" \
				true standard \
				false ip_false \
				false mac_false \
				false ip_mac_false)
	if [ "$MODE" = "" ] 
	then
		exit
	fi	
	case $MODE in
	
		standard) rscanlan $VAL
				;;
		ip_false)  declare IP=$(zenity --entry  --title="rscanlan gui" --text="insert false ip address:"  --entry-text=192.168.1.100)
			       if [ "$IP" = "" ] 
			       then
					exit
				fi	
			       declare MASK=$(zenity --entry  --title="rscanlan gui" --text="insert netmask network:"  --entry-text=255.255.255.0)
			        if [ "$MASK" = "" ] 
				then
					exit
				fi	
				rscanlan  -a $IP -m $MASK $VAL 
				;;
		mac_false)declare MAC=$(zenity --entry  --title="rscanlan gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
				if [ "$MAC" = "" ] 
				then
					exit
				fi	
				rscanlan -h $MAC $VAL
				;;
		
		ip_mac_false)declare IP=$(zenity --entry  --title="rscanlan gui" --text="insert false ip address:"  --entry-text=192.168.1.100)
			             if [ "$IP" = "" ] 
				     then
						exit
				      fi	
				     declare MASK=$(zenity --entry  --title="rscanlan gui" --text="insert netmask network:"  --entry-text=255.255.255.0)
				     if [ "$MASK" = "" ] 
				     then
						exit
				      fi	
				     declare MAC=$(zenity --entry  --title="rscanlan gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
				     if [ "$MAC" = "" ] 
				     then
						exit
				     fi	
				     rscanlan -a $IP -m $MASK -h $MAC $VAL	
				;;
	esac
fi
echo ""
echo -n "Press any key to exit"
read VAL
exit

	
