#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>

declare FILE=$(cat /proc/net/dev)
declare VAL
declare NUM=0
declare INTERFACE
for LINE in $FILE
do
	VAL=$(echo $LINE | sed  -n  {s/:.*//p})
	if [ "$VAL" != ""  ] && [ "$VAL" != "lo" ]
	then	
		if [ $NUM = 0 ]
		then
			NUM=1
			INTERFACE="true $VAL " 
		else
			INTERFACE="$INTERFACE false $VAL "
		fi
	fi
done

if [ $NUM -ge 1 ]
then
	VAL=$(zenity --list --radiolist --title="rgermac gui" --text="select interface" --column="select" --column="interface"  $INTERFACE)
	if [ "$VAL" = "" ] 
	then
		exit
	fi	
	declare MODE=$(zenity --list --radiolist --title="rgetmac gui" --text="select mode" --column="select" --column="mode" \
				true standard \
				false ip_false \
				false mac_false \
				false ip_mac_false)
	if [ "$MODE" = "" ] 
	then
		exit
	fi	
	declare IPREMOTE=$(zenity --entry  --title="rgetmac gui" --text="insert target ip address:"  --entry-text=192.168.1.1)
	if [ "$IPREMOTE" = "" ] 
	then
		exit
	fi	
	case $MODE in
	
		standard)   (
					echo "0"
					declare RESULT=$(rgetmac $VAL $IPREMOTE)
					echo "100"
					zenity --info --title="rgetmac result" --text="$RESULT"	
				) | zenity --progress  --title="rgetmac gui" --text="Running rgetmac..."  --percentage=0 --auto-close
				;;
		ip_false)  declare IP=$(zenity --entry  --title="rgetmac gui" --text="insert false ip address:"  --entry-text=192.168.1.100)
				if [ "$IP" = "" ]
				then 
					exit
				fi
				(
					echo "0"
					declare RESULT=$(rgetmac -a $IP $VAL $IPREMOTE)
					echo "100"
					zenity --info --title="rgetmac result" --text="$RESULT"	
				) | zenity --progress  --title="rgetmac gui" --text="Running rgetmac..."  --percentage=0 --auto-close
				;;
		mac_false)declare MAC=$(zenity --entry  --title="rgetmac gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
				if [ "$MAC" = "" ] 
				then
					exit
				fi	
				(
					echo "0"
					declare RESULT=$(rgetmac -h $MAC $VAL $IPREMOTE)
					echo "100"
					zenity --info --title="rgetmac result" --text="$RESULT"	
				) | zenity --progress  --title="rgetmac gui" --text="Running rgetmac..."  --percentage=0 --auto-close
				;;
		
		ip_mac_false) declare IP=$(zenity --entry  --title="rgetmac gui" --text="insert false ip address:"  --entry-text=192.168.1.100)
				      if [ "$IP" = "" ] 
				      then
						exit
				      fi	
				      declare MAC=$(zenity --entry  --title="rgetmac gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
				      if [ "$MAC" = "" ] 
				      then
						exit
				      fi	
				      (
						echo "0"
						declare RESULT=$(rgetmac -a $IP -h $MAC $VAL $IPREMOTE)
						echo "100"
						zenity --info --title="rgetmac result" --text="$RESULT"	
					) | zenity --progress  --title="rgetmac gui" --text="Running rgetmac..."  --percentage=0 --auto-close	
				
				;;
	esac

fi

