#!/bin/bash

## This script is free software; you can redistribute it and/or modify
##it under the terms of the GNU General Public License version 3 as
##published by the Free Software Foundation;
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
##Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##Author: Marco Guastella <vasta@ragnu.it>

declare FILE=$(cat /proc/net/dev)
declare VAL
declare NUM=0
declare INTERFACE
for LINE in $FILE
do
	VAL=$(echo $LINE | sed  -n  {s/:.*//p})
	if [ "$VAL" != ""  ] && [ "$VAL" != "lo" ]
	then	
		if [ $NUM = 0 ]
		then
			NUM=1
			INTERFACE="true $VAL " 
		else
			INTERFACE="$INTERFACE false $VAL "
		fi
	fi
done

if [ $NUM -ge 1 ]
then
	VAL=$(zenity --list --radiolist --title="rarpcache gui" --text="select interface" --column="select" --column="interface"  $INTERFACE)
	if [ "$VAL" = "" ] 
	then
		exit
	fi
	declare MODE=$(zenity --list --radiolist --title="rarpcache gui" --text="select mode" --column="select" --column="mode" \
				true standard \
				false standard_asim \
				false mac_false \
				false mac_false_asim \
				)
	if [ "$MODE" = "" ] 
	then
		exit
	fi
	declare IPHOST1=$(zenity --entry  --title="rarpcache gui" --text="insert host1 ip address:"  --entry-text=192.168.1.1)			
	if [ "$IPHOST1" = "" ] 
	then
		exit
	fi
	declare IPHOST2=$(zenity --entry  --title="rarpcache gui" --text="insert host2 ip address:"  --entry-text=192.168.1.2)			
	if [ "$IPHOST2" = "" ] 
	then
		exit
	fi
	case $MODE in
				standard)rarpcache $VAL $IPHOST1 $IPHOST2
						;;
				standard_asim)rarpcache -a $VAL $IPHOST1 $IPHOST2
							;;
				mac_false)declare MAC=$(zenity --entry  --title="rarpcache gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
						if [ "$MAC" = "" ] 
						then
							exit
						fi
						rarpcache -h $MAC $VAL $IPHOST1 $IPHOST2
						;;
				mac_false_asim)declare MAC=$(zenity --entry  --title="rarpcache gui" --text="insert false mac address:"  --entry-text=12:34:56:78:99:aa)
							 if [ "$MAC" = "" ] 
							then
								exit
							fi		
							rarpcache -h $MAC -a $VAL $IPHOST1 $IPHOST2
							;;	
	esac	
fi
