/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include <lupin/lupin.h>
#include <stdlib.h>
#include <unistd.h>
#include <upnp/upnp.h>
#include <upnp/upnptools.h>

l_int32 CallBackFxn(Upnp_EventType EventType,void *Event,void *Cookie)
{
	IXML_Document *doc;
	struct Upnp_Action_Complete *ev;
	if(EventType == UPNP_EVENT_SUBSCRIBE_COMPLETE)
		l_std_out("rupnpaction:subscribe complete\n");
	else if(EventType == UPNP_CONTROL_ACTION_COMPLETE)
	{	
		ev = (struct Upnp_Action_Complete *) Event;
		doc = ev->ActionResult;
		if(doc == NULL)
		{	
			l_std_err("rupnpaction error:%s\n",UpnpGetErrorMessage(ev->ErrCode));
			return -1;
		}
		l_std_out("%s\n",ixmlPrintDocument(doc));
	}
	return 0;
}

void usage()
{
	l_std_err("rupnpaction -h {host} -p {port} -s {service} -e {event_path} -c {control_path} -a {action_name} -d {argname1:[arg1].argname2:[arg2]....argnamen:[argn]\n\n"
		    "   OPTIONS:\n   -h\t\thost:host upnp root\n   -p\t\tport:port upnp root\n   -s\t\tservice:service name(name:version)\n"
                    "   -e\t\tevent_path:event path\n   -c\t\tcontrol_path:control path\n   -a\t\taction_name:action name\n   -d\t\tdate:input parameter\n\n");	
}

l_int32 main(l_int32 argc,l_char **argv)
{
	l_int32 c,rc,timeout;
	l_str host=l_str_new(),port=l_str_new(),service=l_str_new(),event=l_str_new(),control=l_str_new(),action=l_str_new(),par=l_str_new();
	l_str cevent=l_str_new(),ccontrol=l_str_new(),cservice=l_str_new(),tmp1;
	l_bool err=FALSE;
	UpnpClient_Handle ch;
	Upnp_SID subsid;
	IXML_Document *dxml;
	l_split split1,split2;
	l_num n1,n2,i;
	/* Command line args */
	while ((c = getopt (argc, argv, "h:p:s:e:c:a:d:")) != -1)
	{
		switch (c)
		{
			case 'h': if(host !=0)
						err=TRUE;
				      l_str_write(&host,"%s",optarg);
				      break;
			case 'p': if(port !=0)
						err=TRUE;
				      l_str_write(&port,"%s",optarg); 
				      break;
			case 's' : if(service !=0)
						err=TRUE; 
				      l_str_write(&service,"%s",optarg);
				      break;
			case 'e': if(event !=0)
						err=TRUE;
				      l_str_write(&event,"%s",optarg);
				      break;
			case 'c': if(control !=0)
						err=TRUE;
				      l_str_write(&control,"%s",optarg);
				      break;
			case 'a':if(action !=0)
						err=TRUE;
				     l_str_write(&action,"%s",optarg);
				     break;		
			case 'd':if(par !=0)
						err=TRUE;
				     l_str_write(&par,"%s",optarg);
				     break;
			default:err=TRUE;
				     break;
		}	
        }
	if(host==0 || port==0 || service==0 || event==0|| control==0 || action==0)
		err=TRUE;
	if(!err)
	{
		if((rc=UpnpInit(NULL,0)) != UPNP_E_SUCCESS)
			err=TRUE;
		else if((rc = UpnpRegisterClient(CallBackFxn,0,&ch)) != UPNP_E_SUCCESS)
			err=TRUE;
		else
		{
			l_str_write(&cevent,"http://%s:%s%s",host,port,event);
			if((rc = UpnpSubscribe(ch,cevent,&timeout,subsid)) != UPNP_E_SUCCESS)
				err=TRUE;		
			else 
			{
				/*crea xml message*/
				l_str_write(&cservice,"urn:schemas-upnp-org:service:%s",service);
				dxml=UpnpMakeAction(action,cservice,0,0);
				if(par != 0)
				{	
					split1=l_str_split(par,".");
					n1=l_str_nsplit(split1);
					i=0;
					while(i<n1 && !err)
					{
						tmp1=l_str_rsplit(split1,i++);
						split2=l_str_split(tmp1,":");
						n2=l_str_nsplit(split2);
						switch(n2)
						{
							case 1:	if((rc=UpnpAddToAction(&dxml,action,cservice,l_str_rsplit(split2,0),"") != UPNP_E_SUCCESS))
										err=TRUE;
									break;
							case 2:	if((rc=UpnpAddToAction(&dxml,action,cservice,l_str_rsplit(split2,0),l_str_rsplit(split2,1)) != UPNP_E_SUCCESS))
										err=TRUE;
									break;
							default:  rc=UPNP_E_INVALID_PARAM;
										err=TRUE;
									break;
						}	
						l_str_freesplit(&split2);
					}		
					l_str_freesplit(&split1);
				}	
				l_str_write(&ccontrol,"http://%s:%s%s",host,port,control);
				if((rc=UpnpSendActionAsync(ch,ccontrol,cservice,0,dxml,CallBackFxn,0)) != UPNP_E_SUCCESS)
					err=TRUE;
				else if((rc= UpnpUnSubscribe(ch,subsid)) != UPNP_E_SUCCESS)
					err=TRUE;
				else if((rc = UpnpUnRegisterClient(ch)) != UPNP_E_SUCCESS)
					err=TRUE;
			}
			UpnpUnRegisterClient(ch);
		}
		if(err)
			l_std_err("rupnaction error:%s\n",UpnpGetErrorMessage(rc));
		UpnpFinish();
	}
	else
		usage();	
	l_str_free(&host);
	l_str_free(&port);
	l_str_free(&service);
	l_str_free(&event);
	l_str_free(&control);
	l_str_free(&action);
	l_str_free(&par);
	l_str_free(&cevent);
	l_str_free(&ccontrol);
	l_str_free(&cservice);
	if(!err)
		exit(EXIT_SUCCESS);
	else
		exit(EXIT_FAILURE);
}
