/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include <lupin/lupin.h>
#include <signal.h>
#include <unistd.h>

#define DEFAULT_PPORT "9050"
#define DEFAULT_PORT "9051"
#define DEFAULT_HOST  "127.0.0.1"
#define DEFAULT_PASS "\"\""

l_str command;
l_str host;
l_str port;
l_str pport;
l_str password;
l_tor tor;
l_out out;
l_com com;

void sfree()
{
	l_str_free(&command);
	l_str_free(&host);
	l_str_free(&port);
	l_str_free(&pport);
	l_str_free(&password);	
	l_tor_free(&tor);
	l_out_free(&out);
	l_com_free(&com);
}

void error(const l_str str)
{
	sfree();
	l_std_error(str);	
}

void torexit(l_int32 i)
{
	sfree();
	l_std_exit(FALSE,0);
}

void usage()
{
	l_std_err("usage:\n");	
	l_std_err("rtor [-e \"command1;command2...\"] [-h tcaddr] [-p tcport] [-s proxyport] [-a pass] \n\n");
	l_std_err("\t-e exec command list(default shell interactive)\n");
	l_std_err("\t-h address tor control(default 127.0.0.1)\n");
	l_std_err("\t-p port tor control service(default 9051)\n");
	l_std_err("\t-s proxyport tor socks service(default 9050)\n");
	l_std_err("\t-a pass authenticate password(default \"\")\n\n");
	sfree();
}

void newidentity(l_abuf data,l_abuf args)
{
	if(l_abuf_size(args) != 1)
		l_std_err("newidentity:invalid arguments\n");
	else
	{
		l_tor_newidentity(tor,out);
		l_out_print(out);
	}
}

void quit(l_abuf data,l_abuf args)
{
	if(l_abuf_size(args) != 1)
		l_std_err("quit:invalid arguments\n");
	else
		torexit(0);
}

void resolve(l_abuf data,l_abuf args)
{
	l_str ip=l_str_new();
	if(l_abuf_size(args) != 2)
		l_std_err("resolve:invalid arguments\n");
	else
	{	
		l_tor_resolve(tor,(const l_str) l_abuf_getmem(args,1,0),&ip,out);
		if(l_out_iserr(out))
			l_out_print(out);
		else
			l_std_out("%s\n",ip);
	}
	l_str_free(&ip);
}

l_int32 main(l_int32 argc,l_char **argv)
{
	/*inizializza argomenti*/
	l_int32 c,narg=argc;
	command=l_str_new();
	host=l_str_new();
	port=l_str_new();
	pport=l_str_new();
	password=l_str_new();
	out=l_out_new();
	com=l_com_new("rtor>");
	l_com_cmd(com,"quit","quit","exit rtorc",quit);
	l_com_cmd(com,"newidentity","newidentity","change identity new tor connection",newidentity);
	l_com_cmd(com,"resolve","resolve host","dns resolve address",resolve);
	tor=0;	
	/*leggere argomenti e verifica validita' con inserimento di eventuali valori di default*/
	while ((c = getopt (argc, argv, "e:h:p:s:a:")) != -1)
	{
		switch(c)
		{
			case  'e':if(! l_str_isnull(command))
						l_std_exit(TRUE,usage);
					narg -=2;
					l_str_write(&command,"%s",optarg);
					break;
			case 'h':if(! l_str_isnull(host))
						l_std_exit(TRUE,usage);
					narg -=2;
					l_str_write(&host,"%s",optarg);
					break;
			case 'p':if(! l_str_isnull(port))
						l_std_exit(TRUE,usage);
					narg -=2;
					l_str_write(&port,"%s",optarg);
					break;
			case 's':if(! l_str_isnull(pport))
						l_std_exit(TRUE,usage);
					narg -=2;
					l_str_write(&pport,"%s",optarg);
					break;
			case 'a':if(! l_str_isnull(password))
						l_std_exit(TRUE,usage);
					narg -=2;
					l_str_write(&password,"%s",optarg);
					break;
			default:	l_std_exit(TRUE,usage);
					break;
				      
		}		
	}
	if(narg != 1)
		l_std_exit(TRUE,usage);		
	if(l_str_isnull(host))
		l_str_write(&host,"%s",DEFAULT_HOST);
	if(l_str_isnull(port))
		l_str_write(&port,"%s",DEFAULT_PORT);
	if(l_str_isnull(pport))
		l_str_write(&pport,"%s",DEFAULT_PPORT);
	if(l_str_isnull(password))
		l_str_write(&password,"%s",DEFAULT_PASS);
	signal(SIGINT,torexit);
	tor=l_tor_new(host,port,password,pport);
	if(l_str_isnull(command))
		while(1)
			l_com_read(com);
	else
		l_com_list(com,command);
	torexit(0);
	return 0;
}

