/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include <lupin/lupin.h>
 
 l_out out;
 
 
void pexit(l_int32 i)
{
	l_out_free(&out);
} 

void usage(l_out out)
{
	l_std_err("usage:rtcpscan host port\n");
	l_std_exit(TRUE,pexit);
}

l_int32 main(l_int32 argc,l_char **argv)
{
	out=l_out_new();
	if(argc != 3)
		usage(out);
	l_tcp_scan(argv[1],argv[2],TRUE,out);
	l_out_assert(out,pexit);
	l_out_print(out);
	l_std_exit(FALSE,pexit);
	return 0;
 }
 
 