/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include <lupin/lupin.h>
 #include <signal.h>
 
l_file file;
l_out out;
l_buf buf;
l_buf obuf;
l_str ip1;
l_str ip2;

void sfree()
{
	l_out_free(&out);
	l_std_fileclose(&file);
	l_buf_free(&buf);
	l_str_free(&ip1);
	l_str_free(&ip2);
}

void pexit(l_int32 i)
{
	sfree();
	l_std_exit(FALSE,0);	
}
 
 void usage()
 {
	l_std_err("usage:riprange {filename}\n");
	l_std_err("\tfile line: ip1 - ip2  with ip1 <= ip2 and type(ip1) = type(ip2)\n");
	l_std_exit(TRUE,0);	
 }
 
 l_int32 main(l_int32 argc,l_char **argv)
 {
	l_split split;
	if(argc != 2)
		l_std_exit(TRUE,usage);
	out=l_out_new();
	buf=l_buf_new();
	file=l_std_openfile(argv[1],"r",out);
	ip1=l_str_new();
	ip2=l_str_new();
	signal(SIGINT,pexit);
	l_out_assert(out,sfree);
	do
	{
		l_buf_reset(buf);
		l_std_filereadline(file,buf,0,out);
		split=l_str_split((l_str) l_buf_mem(buf,0),"-");
		l_str_compact(l_str_rsplit(split,0),&ip1);
		l_str_compact(l_str_rsplit(split,1),&ip2);
		l_buf_reset(buf);
		l_ip_expand(ip1,ip2,buf,TRUE,out);
		l_str_freesplit(&split);
		l_buf_out(buf);
	}while(! l_out_iserr(out));
	pexit(0);	
	return 0;	
 }
      