/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include <unistd.h>
#include <lupin/lupin.h>

l_int32 main(l_int32 argc,l_char **argv)
{
	l_out out;
	l_int32 c;
	l_bool err=FALSE;
	l_str host=l_str_new(),port=l_str_new();
	while ((c = getopt (argc, argv, "h:p:")) != -1)
	{
		switch(c)
		{
			case  'h':  if(host !=0)
						err=TRUE;
					else
						l_str_write(&host,"%s",optarg);
					break;
			case  'p':  if(port !=0)
						err=TRUE;
					else	
						l_str_write(&port,"%s",optarg); 
					break;
			default :  err=TRUE;
					 break;
		}
	}
	if(port == 0)
	{	
		if(argc > 3)
			err=TRUE;
		l_str_write(&port,"80");
	}
	else if(argc > 5)
		err=TRUE;
		
	if(err==TRUE || host == 0|| port == 0)
	{
		l_std_err("usage: rhttpopt -h {host address} -p [port]\n");
		l_str_free(&port);
		l_str_free(&host);
		l_std_exit(FALSE,0);
	}		
	out=l_out_new();
	l_http_options(host,port,out);
	l_out_print(out);
	l_out_free(&out);
	l_str_free(&port);
	l_str_free(&host);
	l_std_exit(FALSE,0);
}
