/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include <lupin/lupin.h>
#include <unistd.h>
#include <stdlib.h>

void usage()
{
	l_std_err("rgetmac  [-a ip_local] [-h mac_address]  device ip_remote\n");
}

l_int32 main(l_int32 argc,l_char **argv)
{
	l_out out;
	l_bool err=FALSE;
	l_int32 c;
	l_str dev=l_str_new();
	l_str ip=l_str_new();
	l_str mac=l_str_new();
	l_str rip=l_str_new();
	l_int32 arg=1;
	while ((c = getopt (argc, argv, "a:h:")) != -1)
	{
		switch(c)
		{
			case 'a':	if(ip != 0)
						err=TRUE;
					else
						l_str_write(&ip,"%s",optarg);	
					arg += 2;
					break;
			case 'h':   if(mac != 0)
						err=TRUE;
					else
						l_str_write(&mac,"%s",optarg);
					arg += 2;
					break;
			default:   err=TRUE;
					break;
		}	
	}
	if(!err && (argc-arg) == 2)
	{
		l_str_write(&dev,"%s",argv[arg++]);
		l_str_write(&rip,"%s",argv[arg]);
		out=l_out_new();
		l_arp_getremotemac2(dev,ip,rip,mac,out);
		l_out_print(out);
		l_out_free(&out);
	}
	else
		err=TRUE;
	l_str_free(&dev);
	l_str_free(&ip);
	l_str_free(&mac);
	l_str_free(&rip);	
	if(err==TRUE)
	{	
		usage();
		exit(EXIT_FAILURE);
	}
	exit(EXIT_SUCCESS);	
}
