/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include <lupin/lupin.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

/*struct deny*/
void *sdeny;

void usage()
{
	l_std_err("rarpdeny {-l macspoof]} device ip_vict ip_deny\n");	
}

void end(l_int32 i)
{
	l_int32 ret;
	l_out out=l_arp_deny_close(&sdeny);
	if(l_out_iserr(out))
	{
		l_out_print(out);
		ret=EXIT_FAILURE;
	}
	else
	{	
		l_std_out("aprdeny routine finish\n");
		ret=EXIT_SUCCESS;
	}
	l_out_free(&out);
	exit(ret);
}

l_int32 main(l_int32 argc,l_char **argv)
{
	l_bool err=FALSE;
	l_int32 c;
	l_str macspoof=l_str_new();
	while ((c = getopt (argc, argv, "l:")) != -1)
	{
		switch(c)
		{
			case 'l': l_str_write(&macspoof,"%s",optarg);
				     argc-=2;
				     break;	
		}
	}
			
	if(argc !=4)
		err=TRUE;
	else
	{
		/*init function deny*/
		sdeny=l_arp_deny_init(argv[3],argv[4],argv[5],macspoof);
		l_str_free(&macspoof);	
		/*signal*/
		signal(SIGINT,end);
		/*thread function*/
		l_arp_deny_exec(sdeny);
		end(0);
	}		
	if(err)
	{	
		l_str_free(&macspoof);
		usage();
		exit(EXIT_FAILURE);
	}
	exit(EXIT_SUCCESS);	
}
