/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include <lupin/lupin.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef linux
#include <endian.h>
#endif

#if (defined(__BYTE_ORDER) && defined(__LITTLE_ENDIAN) && \
     __BYTE_ORDER == __LITTLE_ENDIAN) || \
    (defined(i386) || defined(__i386__) || defined(__i486__) || \
     defined(__i586__) || defined(__i686__) || defined(vax) || defined(MIPSEL))
#define L_ENDIAN 1
#elif (defined(__BYTE_ORDER) && defined(__BIG_ENDIAN) && \
       __BYTE_ORDER == __BIG_ENDIAN) || \
      (defined(sparc) || defined(POWERPC) || defined(mc68000) || defined(sel))
#undef L_ENDIAN
#endif



/*FASTWEB-1-001CA2xxxxxx o FASTWEB-1-001DBXxxxxxx*/
void fastweb_pirelli(const l_str mac)
{
	l_buf input=l_newbuf(),output;
	l_num i=0,j=0;
	l_byte p[6];
	if(l_strlen(mac) == 12 && l_strexatobuf(mac,input,0))
	{	
		l_fwritebuf(input,l_sizebuf(input),"b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b",0x22,0x33,0x11,0x34,0x02,0x81,0xFA,0x22,0x11,0x41,0x68,0x11,0x12,0x01,0x05,0x22,0x71,0x42,0x10,0x66);
		if((output=l_md5(input)) != 0)
		{
			l_stdout("router fastweb pirelli wpa key:");
			while(i<25)
			{
				p[j]=l_bitseqbuf(output,i,5);
				if(p[j] > 0x0a)
					p[j] += 0x57;
				i+=5;
				l_stdout("%02x",p[j]);
				j++;
				
			}
				
			l_stdout("\n");
			l_freebuf(&output);
		}
		else	
			l_stderr("router fastweb pirelli wpa key not found\n");
	}
	else
		l_stderr("router fastweb pirelli wpa key not found\n");
	l_freebuf(&input);
}

void l_mixJenkins(l_uint32 *a,l_uint32 *b,l_uint32 *c)
{
	#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))
	(*a) -= (*c);  
	(*a) ^= rot((*c), 4);  
	(*c) += (*b); 
	(*b) -= (*a);  
	(*b) ^= rot((*a), 6);  
	(*a) += (*c); 
	(*c) -= (*b);  
	(*c) ^= rot((*b), 8);  
	(*b) += (*a); 
	(*a) -= (*c); 
	(*a) ^= rot((*c),16);  
	(*c) += (*b);
	(*b) -= (*a);  
	(*b) ^= rot((*a),19);  
	(*a) += (*c);
	(*c) -= (*b);  
	(*c) ^= rot((*b), 4); 
	(*b) += (*a);
}

void l_finalJenkins(l_uint32 *a,l_uint32 *b,l_uint32 *c)
{
	#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))
	(*c) ^= (*b); 
	(*c) -= rot((*b),14); 
	(*a) ^= (*c); 
	(*a) -= rot((*c),11);
	(*b) ^= (*a); 
	(*b) -= rot((*a),25); 
	(*c) ^= (*b); 
	(*c) -= rot((*b),16); 
	(*a) ^= (*c); 
	(*a) -= rot((*c),4);  
	(*b) ^= (*a); 
	(*b) -= rot((*a),14); 
	(*c) ^= (*b); 
	(*c) -= rot((*b),24);
	
}

l_uint32  l_hashJenkins(const l_uint32 *table,l_size len,l_uint32 initval)
{
	l_uint32 a,b,c;
	a = b = c = 0xdeadbeef + (((l_uint32)len)<<2) + initval;
	while (len > 3) 
	{
		a += table[0]; 
		b += table[1]; 
		c += table[2]; 
		l_mixJenkins(&a,&b,&c); 
		len -= 3; 
		table += 3;
	}
	switch(len) 
	{
		case 3 : c+=table[2]; 
		case 2 : b+=table[1]; 
		case 1 : a+=table[0]; 
		l_finalJenkins(&a,&b,&c); 
		case 0: break;
	}
	return c;
}


/*FASTWEB-1-00036Fxxxxxx oppure FASTWEB-1-002196xxxxxx telsey*/
void fastweb_telsey(const l_str mac)
{
	l_num i,j;
	l_buf mbuf=l_newbuf();
	l_uint32 table[64];
	l_uint32 s1=0,s2=0;
	l_byte pTable[256] = {
			6,2,1,6,2,1,2,6,5,3,4,3,5,4,3,3,3,5,3,1,3,6,4,2,1,5,1,2,2,5,2,1,
			3,5,3,3,4,2,4,5,5,2,5,4,6,2,6,6,3,2,1,6,2,1,2,2,5,3,2,4,4,4,6,3,
			5,5,6,5,6,2,5,1,3,6,1,6,3,2,4,6,6,3,3,5,3,4,2,5,1,5,5,4,4,1,6,4,
			5,4,1,1,4,3,2,2,3,2,3,6,2,4,5,4,1,3,4,5,1,1,3,3,1,1,1,6,2,2,2,5,
			5,1,3,3,4,4,4,1,1,3,5,2,6,6,6,1,1,5,6,1,2,2,6,3,3,3,6,2,4,4,3,4,
			2,1,3,5,2,6,3,6,1,2,5,1,2,2,2,5,3,3,3,3,4,4,4,4,6,5,1,2,5,1,6,6,
			2,1,6,1,1,2,6,2,3,3,5,3,4,5,5,4,5,4,2,6,6,6,2,5,4,1,2,6,4,2,1,5,
			5,3,3,6,5,4,4,2,3,5,4,1,3,4,6,2,4,2,3,4,6,1,2,3,6,4,5,2,1,3,4,1
	};
	if(l_strlen(mac) == 12 && l_strexatobuf(mac,mbuf,0))
	{	
		for(i=0;i<64;i++)
			table[i]=0;
		for (i = 0; i < 64; i++) {
			for (j = 0; j < 4; j++) {
				#ifdef L_ENDIAN
				table[i] <<= 8;
				table[i] |= l_bytebuf(mbuf,pTable[(i*4)+j]-1);
				#else
				table[i] >>= 8;
				table[i] |= l_bytebuf(mbuf,pTable[(i*4)+j]-1} << 24;
				#endif
			}
		}	
		for(i=0;i<64;i++)
			s1=l_hashJenkins(table,i,s1);
		for (i=0; i<64; i++)
		{
			if(i < 8) 
				table[i] <<= 3;
			else if(i<16)
				table[i] >>= 5;
			else if(i<32)
				table[i] >>= 2;
			else
				table[i] <<= 7; 
		}
		for(i=0;i<64;i++)
			s2=l_hashJenkins(table,i,s2);
		s1 &= 0x000fffff;
		s2 &= 0xfffff000;
		s2 >>= 12;
		l_stdout("router fastweb telsey wpa key: %05x%05x\n",s1,s2);
	}
	else
		l_stderr("router fastweb telsey wpa key not found\n");
	l_freebuf(&mbuf);
}

void aliceagpf(const l_str tssid,const l_str mac,const l_str fserial,const l_str k,const l_str q)
{
	l_num i;
	l_buf bmac=l_newbuf(),input=l_newbuf(),output;
	l_str str=l_newstr();
	l_uint32 v1,v0,a0,a1;
	l_bool ret=FALSE;
	l_str sn=l_newstr();
	l_int32 ss,sk,sq;
	unsigned long long hi;
	l_int32 t0;
	l_byte preinitcharset[ ] = {'0','1','2','3','4','5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i','j',
						  'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

	if(l_strmactobuf(mac,bmac,0))
	{
		v1 = l_bytebuf(bmac,2);
		v0 = l_bytebuf(bmac,3);
		a0 = l_bytebuf(bmac,4);
	        a1 = l_bytebuf(bmac,5);
		v1 &= 0x0F;
		v0 <<= 16;
		v1 <<= 24;
		v1 |= v0;
		a0 <<= 8;
		v1 |= a0;
		v1 |= a1;
		hi = 0x55E63B89 * (long long int) v1;
		v0 = hi >> 32;
		v0 >>= 25;
		t0 = v0 * 0x5F5E100;
		l_writestr(&str,"%d",(v1-t0));
		if(l_strcmp(tssid,str) == 0)
		{	
			l_fwritebuf(input,0,"b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b:b",0x64,0xC6,0xDD,0xE3,0xE5,0x79,0xB6,
					0xD9,0x86,0x96,0x8D,0x34,0x45,0xD2,0x3B,0x15,0xCA,0xAF,0x12,0x84,0x02,0xAC,0x56,0x00,0x05,0xCE,0x20,
					0x75,0x91,0x3F,0xDC,0xE8);
			
			if(l_atoi(tssid,&ss) && l_atoi(q,&sq) && l_atoi(k,&sk))
			{	
				l_writestr(&sn,"%sX%07d",fserial,(ss-sq)/sk);
				l_fwritebuf(input,l_sizebuf(input),"s",sn);
				l_catbuf(input,bmac);
				output=l_sha256(input);
				l_stdout("alice router agpf key:");
				for(i=0;i<24;i++)
				{
					v1=l_bytebuf(output,i);		
					l_stdout("%c", preinitcharset[v1%36]);
				}
				l_stdout("\n");
				ret=TRUE;
				l_freebuf(&output);
			}
		}
	}
	l_freestr(&str);
	l_freebuf(&bmac);
	l_freebuf(&input);
	l_freestr(&sn);
	if(!ret)
		l_stderr("router alice agpf key not found\n");
}

void usage()
{
	l_stderr("rwpadefault ssid [mac(alice)] [model(alice)] [k_magic(alice)] [q_magic(alice)]\n");
	exit(EXIT_FAILURE);
}	

l_bool l_isstrprefix(l_str str,l_str prefix)
{
	if(g_str_has_prefix(str,prefix)) 
		return TRUE;
	else
		return FALSE;
}

l_str l_strtail(l_str str,l_num pos)
{
	l_str ret=l_newstr();
	if(pos < l_strlen(str))
		l_writestr(&ret,"%s",&str[pos]);	
	return ret;	
}

l_int32 main(l_int32 argc,l_char **argv)
{
	l_str data;
	if(argc < 2)
		usage();
	if((l_isstrprefix(argv[1],"FASTWEB-1-001CA2") || l_isstrprefix(argv[1],"FASTWEB-1-001DB")) && argc==2)
	{
		data=l_strtail(argv[1],10);
		fastweb_pirelli(data);
	}
	else if((l_isstrprefix(argv[1],"FASTWEB-1-00036F") || l_isstrprefix(argv[1],"FASTWEB-1-002196")) && argc==2)
	{
		data=l_strtail(argv[1],10);
		fastweb_telsey(data);
	}
	else if(l_isstrprefix(argv[1],"alice-") && argc==6)
	{
		data=l_strtail(argv[1],6);
		aliceagpf(data,argv[2],argv[3],argv[4],argv[5]);
	}
	else
		usage();	
	l_freestr(&data);
	exit(EXIT_SUCCESS);	
}
