/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include <lupin/lupin.h>
#include <stdlib.h>
#include <unistd.h>

l_int32 main(l_int32 argc,l_char **argv)
{
	l_out out;
	l_int32 c;
	l_bool err=FALSE;
	l_str host=l_newstr(),port=l_newstr();
	while ((c = getopt (argc, argv, "h:p:")) != -1)
	{
		switch(c)
		{
			case  'h': 	if(host !=0)
						err=TRUE;
					else
						l_writestr(&host,"%s",optarg);
					break;
			case  'p':  if(port !=0)
						err=TRUE;
					else	
						l_writestr(&port,"%s",optarg); 
					break;
			default :  err=TRUE;
					 break;
		}
	}
	if(port == 0)
	{	
		if(argc > 3)
			err=TRUE;
		l_writestr(&port,"80");
	}
	else if(argc > 5)
		err=TRUE;
		
	if(err==TRUE || host == 0|| port == 0)
	{
		l_stderr("usage: rhttpopt -h {host address} -p [port]\n");
		l_freestr(&port);
		l_freestr(&host);
		exit(EXIT_SUCCESS);
	}		
	out=l_newout();
	l_httpoptions(host,port,out);
	l_printout(out);
	l_freeout(&out);
	l_freestr(&port);
	l_freestr(&host);
	exit(EXIT_SUCCESS);
}

