/*author Guastella Marco*/

#include "Scheduler.h"
#include "SObject.h"
#include "Object.h"
#include "Pdnet.h"
#include "config.h"
#include "hdr.h"
#include "Packet.h"
#include <string.h>
#include <stdio.h>

routing::routing(int l)
{
	srtable_= DEFAULT_MAX_TABLE;
	trtable_=0;
	rt_ = new RTABLE[srtable_];
	sconn_ = DEFAULT_MAX_TABLE;
	tconn_ = 0;
	cn_ = new CONNECTION[sconn_];
	nnet_=l;
}
		
routing::~routing()
{
	delete [] rt_;
	delete [] cn_;	
}

void routing::handle(Event *e)
{
	
}
		
void routing::recv(Event *e)
{
	int daddr;
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	if(cmn->htype_[LEVELIP] == HDRIP)
	{
		hdr_ip *ip = (hdr_ip *) &h[Packet::hpos_[LEVELIP]];
		daddr = ip -> daddr_;
	}
	else
	{	
		delete e;
		return;
	}
	int index = -1;
	for(int i=0;i<trtable_;i++)
	{
		if(daddr == rt_[i].address)
		{
			index = rt_[i].dindex;
			break;
		}
	}
	if(index != -1)
	{
		Pdnet &pd = Pdnet::instance();
		pd.send(e,cn_[index].cid,cn_[index].sid);
	}
	else
	{
		delete e;
		return;
	}	
}

int routing::type()
{
	return TYPE_ROUTING;		
}

int routing::addConn(int t,int da,int c,int s)
{
	
	if(sconn_ == tconn_)
	{
		CONNECTION *tmp = cn_;
		sconn_ *= 2;
		cn_ = new CONNECTION[sconn_];
		memcpy(cn_,tmp,tconn_*sizeof(CONNECTION)); 
		delete [] tmp;
	}
	cn_[tconn_].type = t;
	cn_[tconn_].daddr = da;
	cn_[tconn_].cid = c;
	cn_[tconn_++].sid = s;
	return tconn_-1;
}

int routing::addRoute(int a,double t,int index)
{
	if(index >= tconn_)
		return -1;
	for(int i=0;i < trtable_;i++)
	{
		if(a == rt_[i].address)
		{
			rt_[i].dindex = index;
			if(cn_[index].type == TYPE_ROUTING)
				return cn_[index].sid;
			return -1;
		}
	}
	if(trtable_ == srtable_)
	{
		RTABLE *tmp = rt_;
		srtable_ *= 2;
		rt_ = new RTABLE[srtable_];
		memcpy(rt_,tmp,srtable_*sizeof(RTABLE)); 
		delete [] tmp;
	}	
	rt_[trtable_].address = a;
	rt_[trtable_].time = t;
	rt_[trtable_++].dindex = index;
	if(cn_[index].type == TYPE_ROUTING)
		return cn_[index].sid;
	return -1;
}

double routing::getTime(int address,int *st)
{
	for(int i=0; i < trtable_;i++)
	{	
		if(address == rt_[i].address)
		{	
			if(cn_[i].type == TYPE_ROUTING)
			{	
				(*st) = cn_[i].sid;	
				return 0.0;
			}
			(*st) = -1;
			return rt_[i].time;
		}
	}
	(*st) = -1;
	return 0.0;
}

void routing::supdate(CommBuffer *c)
{

}

void routing::rupdate(CommBuffer *c)
{

}

void routing::print(int c)
{
	printf("Link Nodo %d:\n",c);
	for(int i=0;i < tconn_; i++)
		printf("index %d type %d daddr %d cid %d sid %d\n",i,cn_[i].type,cn_[i].daddr,cn_[i].cid,cn_[i].sid);
	printf("\n");
	printf("routing table nodo %d size %d\n",c,trtable_);
	for(int i=0;i<trtable_;i++)
		printf("address %d time %f dindex %d\n",rt_[i].address,rt_[i].time,rt_[i].dindex);
	printf("\n");
}

